/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class RemoveInstancesWithMissingValue
extends SimpleBatchFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = -8611897473185237907L;
    protected boolean m_IgnoreClass = false;

    public String globalInfo() {
        return "Removes all instances that contain missing values.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tWhether to ignore the class attribute.\n\t(default: off)", "ignore-class", 0, "-ignore-class"));
        return result.elements();
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        if (this.getIgnoreClass()) {
            result.add("-ignore-class");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        this.setIgnoreClass(Utils.getFlag((String)"ignore-class", (String[])options));
    }

    public void setIgnoreClass(boolean value) {
        this.m_IgnoreClass = value;
    }

    public boolean getIgnoreClass() {
        return this.m_IgnoreClass;
    }

    public String ignoreClassTipText() {
        return "If true, the class attribute is not taken into account.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat, 0);
    }

    protected Instances process(Instances instances) throws Exception {
        Instances result = new Instances(instances, instances.numInstances());
        int classIndex = instances.classIndex();
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance inst = instances.instance(i);
            boolean missing = false;
            for (int n = 0; n < inst.numAttributes(); ++n) {
                if (this.m_IgnoreClass && n == classIndex || !inst.isMissing(n)) continue;
                missing = true;
                break;
            }
            if (!missing) {
                result.add((Instance)new DenseInstance(inst));
                continue;
            }
            if (!this.m_Debug) continue;
            System.out.println("Instance #" + (i + 1) + " contains missing value(s).");
        }
        result.compactify();
        if (this.m_Debug) {
            System.out.println("Reduction: " + instances.numInstances() + " -> " + result.numInstances());
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 7198 $");
    }

    public static void main(String[] args) {
        RemoveInstancesWithMissingValue.runFilter((Filter)new RemoveInstancesWithMissingValue(), (String[])args);
    }
}

