/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.container.DataPoint;
import adams.data.conversion.AbstractConversion;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.data.weka.WekaAttributeIndex;
import java.util.Date;
import weka.core.Instance;
import weka.core.Instances;

public class WekaInstancesToTimeseries
extends AbstractConversion {
    private static final long serialVersionUID = 3934411483801077460L;
    protected WekaAttributeIndex m_DateAttribute;
    protected WekaAttributeIndex m_ValueAttribute;

    public String globalInfo() {
        return "Turns a WEKA Instances object into a Timeseries.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("date-attribute", "dateAttribute", (Object)new WekaAttributeIndex("1"));
        this.m_OptionManager.add("value-attribute", "valueAttribute", (Object)new WekaAttributeIndex("2"));
    }

    public void setDateAttribute(WekaAttributeIndex value) {
        this.m_DateAttribute = value;
        this.reset();
    }

    public WekaAttributeIndex getDateAttribute() {
        return this.m_DateAttribute;
    }

    public String dateAttributeTipText() {
        return "The index of the date attribute in the dataset to use a timestamp for the timeseries data points.";
    }

    public void setValueAttribute(WekaAttributeIndex value) {
        this.m_ValueAttribute = value;
        this.reset();
    }

    public WekaAttributeIndex getValueAttribute() {
        return this.m_ValueAttribute;
    }

    public String valueAttributeTipText() {
        return "The index of the attribute with the timeseries values in the dataset.";
    }

    public Class accepts() {
        return Instances.class;
    }

    public Class generates() {
        return Timeseries.class;
    }

    protected Object doConvert() throws Exception {
        Instances input = (Instances)this.m_Input;
        this.m_DateAttribute.setData((Object)input);
        int indexDate = this.m_DateAttribute.getIntIndex();
        if (indexDate == -1) {
            throw new IllegalStateException("Failed to located date attribute: " + this.m_DateAttribute.getIndex());
        }
        this.m_ValueAttribute.setData((Object)input);
        int indexValue = this.m_ValueAttribute.getIntIndex();
        if (indexValue == -1) {
            throw new IllegalStateException("Failed to located value attribute: " + this.m_ValueAttribute.getIndex());
        }
        Timeseries result = new Timeseries(input.relationName() + "-" + input.attribute(indexValue).name());
        for (int i = 0; i < input.numInstances(); ++i) {
            Instance inst = input.instance(i);
            if (inst.isMissing(indexDate) || inst.isMissing(indexValue)) continue;
            Date timestamp = new Date((long)inst.value(indexDate));
            double value = inst.value(indexValue);
            TimeseriesPoint point = new TimeseriesPoint(timestamp, value);
            result.add((DataPoint)point);
        }
        return result;
    }
}

