/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.timeseriessplit;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.container.DataPoint;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.flow.transformer.timeseriessplit.AbstractTimeseriesSplitter;
import java.util.ArrayList;

public class FixedLengthSegments
extends AbstractTimeseriesSplitter {
    private static final long serialVersionUID = 259240444289354690L;
    protected int m_NumPoints;
    protected boolean m_DiscardPartial;

    public String globalInfo() {
        return "Splits the timeseries into segements of a fixed length, i.e., number of data points.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-points", "numPoints", (Object)100, (Number)1, null);
        this.m_OptionManager.add("discard-partial", "discardPartial", (Object)false);
    }

    public void setNumPoints(int value) {
        if (value >= 1) {
            this.m_NumPoints = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of data points must be at least 1, provided: " + value);
        }
    }

    public int getNumPoints() {
        return this.m_NumPoints;
    }

    public String numPointsTipText() {
        return "The number of data points for a segment.";
    }

    public void setDiscardPartial(boolean value) {
        this.m_DiscardPartial = value;
        this.reset();
    }

    public boolean getDiscardPartial() {
        return this.m_DiscardPartial;
    }

    public String discardPartialTipText() {
        return "If enabled, partial segments get discarded, ie the last one if not sufficient data points.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"numPoints", (Object)this.m_NumPoints, (String)"# points: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"discardPartial", (boolean)this.m_DiscardPartial, (String)"no partial", (String)", ");
        return result;
    }

    @Override
    protected Timeseries[] doSplit(Timeseries series) {
        ArrayList<Timeseries> result = new ArrayList<Timeseries>();
        Timeseries current = null;
        for (Object p : series.toList()) {
            TimeseriesPoint point = (TimeseriesPoint)((Object)p);
            if (current == null) {
                current = series.getHeader();
                result.add(current);
            }
            if (current.size() < this.m_NumPoints) {
                current.add((DataPoint)point.getClone());
            }
            if (current.size() != this.m_NumPoints) continue;
            current = null;
        }
        if (this.m_DiscardPartial && result.size() > 0 && ((Timeseries)((Object)result.get(result.size() - 1))).size() < this.m_NumPoints) {
            result.remove(result.size() - 1);
        }
        return result.toArray(new Timeseries[result.size()]);
    }
}

