/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.axis;

import adams.data.timeseries.PeriodicityHelper;
import adams.data.timeseries.PeriodicityType;
import adams.gui.visualization.core.axis.AbstractTickGenerator;
import adams.gui.visualization.core.axis.Formatter;
import adams.gui.visualization.core.axis.Tick;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.Date;
import java.util.GregorianCalendar;

public class PeriodicityTickGenerator
extends AbstractTickGenerator {
    private static final long serialVersionUID = -3950212023344727427L;
    protected PeriodicityType m_Periodicity;
    protected Formatter m_Formatter;

    public String globalInfo() {
        return "A periodicity tick generator.";
    }

    protected void initialize() {
        super.initialize();
        this.m_Formatter = Formatter.getDateFormatter((String)this.getDefaultFormat());
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("periodicity", "periodicity", (Object)PeriodicityType.NONE);
        this.m_OptionManager.add("format", "format", (Object)this.getDefaultFormat());
    }

    public void setPeriodicity(PeriodicityType value) {
        this.m_Periodicity = value;
        this.reset();
    }

    public PeriodicityType getPeriodicity() {
        return this.m_Periodicity;
    }

    public String periodicityTipText() {
        return "The type of periodicity to use.";
    }

    protected String getDefaultFormat() {
        return "y/M/d";
    }

    public void setFormat(String value) {
        this.m_Formatter.applyPattern(value);
        this.reset();
    }

    public String getFormat() {
        return this.m_Formatter.toPattern();
    }

    public String formatTipText() {
        return "The format to use for the ticks (numeric or date/time).";
    }

    protected void doGenerate() {
        double left = this.m_Parent.getActualMinimum();
        Date leftDate = new Date((long)left);
        GregorianCalendar leftCal = new GregorianCalendar();
        leftCal.setTime(leftDate);
        double right = this.m_Parent.getActualMaximum();
        Date rightDate = new Date((long)right);
        GregorianCalendar rightCal = new GregorianCalendar();
        rightCal.setTime(rightDate);
        TDoubleArrayList val = PeriodicityHelper.calculate(this.m_Periodicity, left, leftDate, leftCal, right, rightDate, rightCal);
        int current = -1;
        for (int i = 0; i < val.size(); ++i) {
            int last = current;
            current = this.m_Parent.valueToPos(val.get(i));
            if (current == last) continue;
            String label = this.fixLabel(this.m_Formatter.format(Double.valueOf(val.get(i))));
            this.m_Ticks.add(new Tick(current, label));
            this.addLabel(label);
        }
    }
}

