/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.timeseries;

import adams.core.base.BaseDateTime;
import adams.data.timeseries.PeriodicityType;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.axis.PeriodicityTickGenerator;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.timeseries.AbstractTimeseriesXAxisPanelOptions;
import adams.gui.visualization.timeseries.TimeseriesPanel;
import java.awt.Container;

public class DefaultTimeseriesXAxisPanelOptions
extends AbstractTimeseriesXAxisPanelOptions {
    private static final long serialVersionUID = -1774995113138870653L;
    protected PeriodicityType m_Periodicity;
    protected boolean m_Fixed;
    protected BaseDateTime m_Minimum;
    protected BaseDateTime m_Maximum;

    public String globalInfo() {
        return "Encapsulates options for the X axis in a timeseries plot.\nIt is possible to fix the range of the axis as well.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("periodicity", "periodicity", (Object)PeriodicityType.NONE);
        this.m_OptionManager.add("fixed", "fixed", (Object)false);
        this.m_OptionManager.add("minimum", "minimum", (Object)new BaseDateTime("-INF"));
        this.m_OptionManager.add("maximum", "maximum", (Object)new BaseDateTime("+INF"));
    }

    public void setPeriodicity(PeriodicityType value) {
        this.m_Periodicity = value;
        this.reset();
    }

    public PeriodicityType getPeriodicity() {
        return this.m_Periodicity;
    }

    public String periodicityTipText() {
        return "The type of periodicity to use for the background.";
    }

    public void setFixed(boolean value) {
        this.m_Fixed = value;
        this.reset();
    }

    public boolean getFixed() {
        return this.m_Fixed;
    }

    public String fixedTipText() {
        return "If enabled, fixed minimum/maximum are used for the axis.";
    }

    public void setMinimum(BaseDateTime value) {
        this.m_Minimum = value;
        this.reset();
    }

    public BaseDateTime getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum for the axis, if fixed.";
    }

    public void setMaximum(BaseDateTime value) {
        this.m_Maximum = value;
        this.reset();
    }

    public BaseDateTime getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum for the axis, if fixed.";
    }

    public void configure(PlotPanel plot, Axis axis) {
        super.configure(plot, axis);
        Object parent = GUIHelper.getParent((Container)plot, TimeseriesPanel.class);
        if (parent != null) {
            TimeseriesPanel panel = (TimeseriesPanel)((Object)parent);
            panel.getPeriodicityPaintlet().setPeriodicity(this.m_Periodicity);
            if (this.m_Fixed) {
                panel.setMinX(this.m_Minimum);
                panel.setMaxX(this.m_Maximum);
            } else {
                panel.setMinX(null);
                panel.setMaxX(null);
            }
        }
        if (plot.getAxis(axis).getTickGenerator() instanceof PeriodicityTickGenerator) {
            ((PeriodicityTickGenerator)plot.getAxis(axis).getTickGenerator()).setPeriodicity(this.m_Periodicity);
        }
    }
}

