/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.timeseries;

import adams.core.CleanUpHandler;
import adams.core.Properties;
import adams.core.StatusMessageHandler;
import adams.core.base.BaseObject;
import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionUtils;
import adams.data.filter.AbstractFilter;
import adams.data.filter.PassThrough;
import adams.data.io.input.AbstractDataContainerReader;
import adams.data.timeseries.PeriodicityHelper;
import adams.data.timeseries.PeriodicityType;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.data.timeseries.TimeseriesUtils;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionHandler;
import adams.db.SQLStatement;
import adams.event.DatabaseConnectionChangeEvent;
import adams.event.DatabaseConnectionChangeListener;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.source.SequenceSource;
import adams.flow.source.StringConstants;
import adams.flow.transformer.AbstractReportDbUpdater;
import adams.flow.transformer.TimeseriesDbReader;
import adams.flow.transformer.TimeseriesReportDbUpdater;
import adams.gui.chooser.TimeseriesFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.SearchPanel;
import adams.gui.core.Undo;
import adams.gui.core.UndoPanel;
import adams.gui.event.DataChangeEvent;
import adams.gui.event.DataChangeListener;
import adams.gui.event.FilterEvent;
import adams.gui.event.FilterListener;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.event.UndoEvent;
import adams.gui.goe.GenericObjectEditor;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.scripting.AbstractScriptingEngine;
import adams.gui.scripting.ScriptingDialog;
import adams.gui.scripting.ScriptingEngine;
import adams.gui.scripting.ScriptingEngineHandler;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.container.AbstractContainerManager;
import adams.gui.visualization.container.ContainerListManager;
import adams.gui.visualization.container.ContainerTable;
import adams.gui.visualization.container.DataContainerPanel;
import adams.gui.visualization.container.FilterDialog;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.axis.PeriodicityTickGenerator;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.report.ReportFactory;
import adams.gui.visualization.timeseries.TimeseriesContainer;
import adams.gui.visualization.timeseries.TimeseriesContainerManager;
import adams.gui.visualization.timeseries.TimeseriesImportDatabaseDialog;
import adams.gui.visualization.timeseries.TimeseriesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimeseriesExplorer
extends UndoPanel
implements MenuBarProvider,
StatusMessageHandler,
ContainerListManager<TimeseriesContainerManager>,
DataChangeListener,
ScriptingEngineHandler,
CleanUpHandler,
FilterListener<Timeseries>,
SendToActionSupporter,
DatabaseConnectionHandler,
DatabaseConnectionChangeListener {
    private static final long serialVersionUID = 3953271131937711340L;
    protected TimeseriesPanel m_PanelTimeseries;
    protected BaseStatusBar m_StatusBar;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemClearData;
    protected JCheckBoxMenuItem m_MenuItemEnableUndo;
    protected JMenuItem m_MenuItemUndo;
    protected JMenuItem m_MenuItemRedo;
    protected JMenuItem m_MenuItemFilter;
    protected JMenu m_MenuScripts;
    protected JMenuItem m_MenuItemStartRecording;
    protected JMenuItem m_MenuItemStopRecording;
    protected JMenuItem m_MenuItemOverlayFlowOutput;
    protected JMenuItem m_MenuItemRefreshScripts;
    protected JMenu m_MenuView;
    protected JMenuItem m_MenuItemViewSelectedTimestamp;
    protected JMenuItem m_MenuItemViewZoomOverview;
    protected JMenuItem m_MenuItemViewAntiAliasing;
    protected JMenu m_MenuItemViewPeriodicity;
    protected JMenuItem m_MenuItemViewColorProvider;
    protected GenericObjectEditor m_GenericObjectEditorCorrelationStatistics;
    protected AbstractFilter<Timeseries> m_CurrentFilter;
    protected boolean m_FilterOverlayOriginalData;
    protected FilterDialog m_DialogFilter;
    protected TimeseriesFileChooser m_TimeseriesFileChooser;
    protected ScriptingDialog m_ScriptingDialog;
    protected BaseTabbedPane m_TabbedPane;
    protected ReportFactory.Panel m_Reports;
    protected SearchPanel m_SearchPanel;
    protected AbstractDatabaseConnection m_DatabaseConnection;
    protected TimeseriesImportDatabaseDialog m_DialogSQL;
    protected GenericObjectEditorDialog m_DialogColorProvider;

    public TimeseriesExplorer() {
        super(Timeseries.class, true);
    }

    protected void initialize() {
        super.initialize();
        this.m_ScriptingDialog = null;
        this.m_DialogColorProvider = null;
        this.m_TimeseriesFileChooser = new TimeseriesFileChooser();
        this.m_TimeseriesFileChooser.setMultiSelectionEnabled(true);
        this.m_CurrentFilter = new PassThrough();
        this.m_DialogSQL = null;
        this.m_DatabaseConnection = this.getDefaultDatabaseConnection();
        this.m_DatabaseConnection.addChangeListener((DatabaseConnectionChangeListener)this);
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TabbedPane = new BaseTabbedPane();
        this.add((Component)this.m_TabbedPane, "Center");
        JPanel panelData = new JPanel(new BorderLayout());
        this.m_TabbedPane.addTab("Data", (Component)panelData);
        this.m_TabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ContainerTable dtable = TimeseriesExplorer.this.getTimeseriesPanel().getTimeseriesContainerList().getTable();
                if (TimeseriesExplorer.this.m_TabbedPane.getSelectedIndex() == 0) {
                    ContainerTable rtable = TimeseriesExplorer.this.m_Reports.getReportContainerList().getTable();
                    if (rtable == null || rtable.getSelectedRowCount() != 1) {
                        return;
                    }
                    int row = rtable.getSelectedRow();
                    dtable.getSelectionModel().clearSelection();
                    dtable.getSelectionModel().setSelectionInterval(row, row);
                } else if (TimeseriesExplorer.this.m_TabbedPane.getSelectedIndex() == 1) {
                    if (dtable.getSelectedRowCount() != 1) {
                        return;
                    }
                    TimeseriesExplorer.this.m_Reports.setCurrentTable(dtable.getSelectedRow());
                }
            }
        });
        this.m_PanelTimeseries = new TimeseriesPanel();
        this.m_PanelTimeseries.getContainerManager().addDataChangeListener((DataChangeListener)this);
        this.m_PanelTimeseries.setStatusMessageHandler(this);
        panelData.add((Component)((Object)this.m_PanelTimeseries), "Center");
        JPanel panelReport = new JPanel(new BorderLayout());
        this.m_TabbedPane.addTab("Report", (Component)panelReport);
        this.m_Reports = ReportFactory.getPanel((List)null);
        this.m_Reports.setDataContainerPanel((DataContainerPanel)this.m_PanelTimeseries);
        panelReport.add((Component)this.m_Reports, "Center");
        this.m_SearchPanel = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        this.m_SearchPanel.addSearchListener(new SearchListener(){

            public void searchInitiated(SearchEvent e) {
                TimeseriesExplorer.this.m_Reports.search(TimeseriesExplorer.this.m_SearchPanel.getSearchText(), TimeseriesExplorer.this.m_SearchPanel.isRegularExpression());
                TimeseriesExplorer.this.m_SearchPanel.grabFocus();
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.m_SearchPanel, "West");
        panelReport.add((Component)panel, "South");
        this.m_StatusBar = new BaseStatusBar();
        this.add((Component)this.m_StatusBar, "South");
        this.getTimeseriesPanel().getPlot().getContent().addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TimeseriesPoint point = TimeseriesExplorer.this.getTimeseriesPanel().getSelectedTimestampPaintlet().getPoint();
                if (point == null && TimeseriesExplorer.this.getContainerManager().countVisible() > 0) {
                    for (int i = 0; i < TimeseriesExplorer.this.getContainerManager().count(); ++i) {
                        List points;
                        if (!TimeseriesExplorer.this.getContainerManager().isVisible(i) || (points = ((TimeseriesContainer)TimeseriesExplorer.this.getContainerManager().get(i)).getData().toList()).size() <= 0) continue;
                        point = (TimeseriesPoint)((Object)points.get(points.size() / 2));
                        TimeseriesExplorer.this.getTimeseriesPanel().getSelectedTimestampPaintlet().setPoint(point);
                        break;
                    }
                }
            }
        });
        this.getTimeseriesPanel().getPlot().getContent().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Timeseries data;
                int movement = 0;
                TimeseriesPoint point = TimeseriesExplorer.this.getTimeseriesPanel().getSelectedTimestampPaintlet().getPoint();
                if (point != null) {
                    if (e.getKeyCode() == 37) {
                        if (!e.isAltDown() && !e.isControlDown()) {
                            movement = e.isShiftDown() ? -10 : -1;
                            e.consume();
                        }
                    } else if (e.getKeyCode() == 39 && !e.isAltDown() && !e.isControlDown()) {
                        movement = e.isShiftDown() ? 10 : 1;
                        e.consume();
                    }
                }
                if (movement != 0 && (data = (Timeseries)point.getParent()) != null) {
                    int index = TimeseriesUtils.findTimestamp((List<TimeseriesPoint>)data.toList(), point);
                    if ((index += movement) < 0) {
                        index = 0;
                    }
                    if (index >= data.size()) {
                        index = data.size() - 1;
                    }
                    TimeseriesPoint newPoint = (TimeseriesPoint)((Object)data.toList().get(index));
                    TimeseriesExplorer.this.getTimeseriesPanel().getSelectedTimestampPaintlet().setPoint(newPoint);
                }
                if (!e.isConsumed()) {
                    super.keyPressed(e);
                }
            }
        });
        this.getTimeseriesPanel().getSelectedTimestampPaintlet().setEnabled(false);
    }

    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    public TimeseriesPanel getTimeseriesPanel() {
        return this.m_PanelTimeseries;
    }

    public void showStatus(String msg) {
        this.m_StatusBar.showStatus(msg);
    }

    public void dataChanged(DataChangeEvent e) {
        this.updateMenu();
    }

    public AbstractScriptingEngine getScriptingEngine() {
        return ScriptingEngine.getSingleton((AbstractDatabaseConnection)DatabaseConnection.getSingleton());
    }

    public void undoOccurred(UndoEvent e) {
        this.updateMenu();
    }

    public TimeseriesContainerManager getContainerManager() {
        return (TimeseriesContainerManager)this.m_PanelTimeseries.getContainerManager();
    }

    public void setContainerManager(TimeseriesContainerManager value) {
        this.m_PanelTimeseries.setContainerManager((AbstractContainerManager)value);
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        boolean dataLoaded = this.getContainerManager().count() > 0;
        this.m_MenuItemClearData.setEnabled(dataLoaded);
        this.m_MenuItemEnableUndo.setSelected(this.m_Undo.isEnabled());
        this.m_MenuItemUndo.setEnabled(this.m_Undo.canUndo());
        if (this.m_Undo.canUndo()) {
            this.m_MenuItemUndo.setText("Undo - " + this.m_Undo.peekUndoComment(true));
            this.m_MenuItemUndo.setToolTipText(this.m_Undo.peekUndoComment());
        } else {
            this.m_MenuItemUndo.setText("Undo");
            this.m_MenuItemUndo.setToolTipText(null);
        }
        this.m_MenuItemRedo.setEnabled(this.m_Undo.canRedo());
        if (this.m_Undo.canRedo()) {
            this.m_MenuItemRedo.setText("Redo - " + this.m_Undo.peekRedoComment(true));
            this.m_MenuItemRedo.setToolTipText(this.m_Undo.peekRedoComment());
        } else {
            this.m_MenuItemRedo.setText("Redo");
            this.m_MenuItemRedo.setToolTipText(null);
        }
        this.m_MenuItemFilter.setEnabled(dataLoaded);
        this.m_MenuItemStartRecording.setEnabled(!this.getScriptingEngine().isRecording());
        this.m_MenuItemStopRecording.setEnabled(this.getScriptingEngine().isRecording());
    }

    public void refreshScripts() {
        List scripts = this.getScriptingEngine().getAvailableScripts();
        int i = 0;
        while (i < this.m_MenuScripts.getItemCount()) {
            if (this.m_MenuScripts.getItem(i) != this.m_MenuItemRefreshScripts) {
                ++i;
                continue;
            }
            ++i;
            while (i < this.m_MenuScripts.getItemCount()) {
                this.m_MenuScripts.remove(i);
            }
        }
        this.m_MenuScripts.addSeparator();
        if (scripts.size() > 0) {
            for (i = 0; i < scripts.size(); ++i) {
                final File file = new File((String)scripts.get(i));
                String name = file.getName().replaceAll("_", " ");
                final boolean isFlow = name.endsWith(".flow");
                if (isFlow) {
                    name = name.replaceAll("\\.flow$", "") + " [Flow]";
                }
                JMenuItem menuitem = new JMenuItem(name);
                this.m_MenuScripts.add(menuitem);
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TimeseriesExplorer.this.getScriptingEngine().clear();
                        if (isFlow) {
                            if (TimeseriesExplorer.this.m_MenuItemOverlayFlowOutput.isSelected()) {
                                TimeseriesExplorer.this.getScriptingEngine().add((BasePanel)TimeseriesExplorer.this, "run-flow-overlay " + file.getAbsolutePath());
                            } else {
                                TimeseriesExplorer.this.getScriptingEngine().add((BasePanel)TimeseriesExplorer.this, "run-flow " + file.getAbsolutePath());
                            }
                        } else {
                            TimeseriesExplorer.this.getScriptingEngine().add((BasePanel)TimeseriesExplorer.this, file);
                        }
                    }
                });
            }
        } else {
            JMenuItem menuitem = new JMenuItem("no scripts available");
            menuitem.setEnabled(false);
            this.m_MenuScripts.add(menuitem);
        }
    }

    public void manageScripts() {
        if (this.m_ScriptingDialog == null) {
            this.m_ScriptingDialog = this.getParentDialog() != null ? new ScriptingDialog(this.getParentDialog(), (BasePanel)this) : new ScriptingDialog(this.getParentFrame(), (BasePanel)this);
            this.m_ScriptingDialog.setLocationRelativeTo((Component)((Object)this));
        }
        this.m_ScriptingDialog.setVisible(true);
    }

    public void startRecording() {
        if (!this.getScriptingEngine().isRecording()) {
            this.getScriptingEngine().startRecording();
        }
        this.updateMenu();
    }

    public void stopRecording() {
        if (this.getScriptingEngine().isRecording()) {
            this.getScriptingEngine().stopRecording();
        }
        this.updateMenu();
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TimeseriesExplorer.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Clear data");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed N"));
            menuitem.setIcon(GUIHelper.getIcon((String)"new.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeseriesExplorer.this.clearData();
                }
            });
            this.m_MenuItemClearData = menuitem;
            menuitem = new JMenuItem("Load data from disk...");
            menu.add(menuitem);
            menuitem.setMnemonic('o');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl shift pressed O"));
            menuitem.setIcon(GUIHelper.getIcon((String)"open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeseriesExplorer.this.loadDataFromDisk();
                }
            });
            menuitem = new JMenuItem("Load data from DB...");
            menu.add(menuitem);
            menuitem.setMnemonic('B');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeseriesExplorer.this.loadDataFromDatabase();
                }
            });
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, (JMenu)menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeseriesExplorer.this.close();
                }
            });
            menu = new JMenu("Edit");
            result.add(menu);
            menu.setMnemonic('E');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TimeseriesExplorer.this.updateMenu();
                }
            });
            menuitem = new JCheckBoxMenuItem("Undo enabled");
            menu.add(menuitem);
            menuitem.setMnemonic('n');
            ((JCheckBoxMenuItem)menuitem).setSelected(this.m_Undo.isEnabled());
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TimeseriesExplorer.this.m_MenuItemEnableUndo.isSelected()) {
                        TimeseriesExplorer.this.getScriptingEngine().add((BasePanel)TimeseriesExplorer.this, "enable-undo");
                    } else {
                        TimeseriesExplorer.this.getScriptingEngine().add((BasePanel)TimeseriesExplorer.this, "disable-undo");
                    }
                }
            });
            this.m_MenuItemEnableUndo = (JCheckBoxMenuItem)menuitem;
            menuitem = new JMenuItem("Undo");
            menu.add(menuitem);
            menuitem.setMnemonic('U');
            menuitem.setEnabled(this.m_Undo.canUndo());
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Z"));
            menuitem.setIcon(GUIHelper.getIcon((String)"undo.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeseriesExplorer.this.undo();
                }
            });
            this.m_MenuItemUndo = menuitem;
            menuitem = new JMenuItem("Redo");
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.setEnabled(this.m_Undo.canUndo());
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Y"));
            menuitem.setIcon(GUIHelper.getIcon((String)"redo.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeseriesExplorer.this.redo();
                }
            });
            this.m_MenuItemRedo = menuitem;
            menu = new JMenu("Process");
            result.add(menu);
            menu.setMnemonic('P');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TimeseriesExplorer.this.updateMenu();
                }
            });
            menuitem = new JMenuItem("Filter...");
            menu.add(menuitem);
            menuitem.setMnemonic('F');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed F"));
            menuitem.setIcon(GUIHelper.getIcon((String)"run.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeseriesExplorer.this.filter();
                }
            });
            this.m_MenuItemFilter = menuitem;
            menu = new JMenu("Scripts");
            result.add(menu);
            menu.setMnemonic('S');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TimeseriesExplorer.this.updateMenu();
                }
            });
            this.m_MenuScripts = menu;
            menuitem = new JMenuItem("Manage...");
            menu.add(menuitem);
            menuitem.setMnemonic('m');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed M"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeseriesExplorer.this.manageScripts();
                }
            });
            menuitem = new JMenuItem("Start recording");
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeseriesExplorer.this.startRecording();
                }
            });
            this.m_MenuItemStartRecording = menuitem;
            menuitem = new JMenuItem("Stop recording");
            menu.add(menuitem);
            menuitem.setMnemonic('t');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeseriesExplorer.this.stopRecording();
                }
            });
            this.m_MenuItemStopRecording = menuitem;
            menuitem = new JCheckBoxMenuItem("Overlay flow output");
            menu.add(menuitem);
            menuitem.setMnemonic('o');
            menuitem.setSelected(true);
            this.m_MenuItemOverlayFlowOutput = menuitem;
            menuitem = new JMenuItem("Refresh");
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeseriesExplorer.this.refreshScripts();
                }
            });
            this.m_MenuItemRefreshScripts = menuitem;
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TimeseriesExplorer.this.updateMenu();
                }
            });
            this.m_MenuView = menu;
            menuitem = new JCheckBoxMenuItem("Display selected timestamp");
            menu.add(menuitem);
            menuitem.setMnemonic('G');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl shift pressed W"));
            menuitem.setSelected(this.getTimeseriesPanel().getSelectedTimestampPaintlet().isEnabled());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeseriesExplorer.this.getTimeseriesPanel().getSelectedTimestampPaintlet().setEnabled(TimeseriesExplorer.this.m_MenuItemViewSelectedTimestamp.isSelected());
                    TimeseriesExplorer.this.getTimeseriesPanel().update();
                }
            });
            this.m_MenuItemViewSelectedTimestamp = menuitem;
            menuitem = new JCheckBoxMenuItem("Display zoom overview");
            menu.add(menuitem);
            menuitem.setMnemonic('Z');
            menuitem.setSelected(this.isZoomOverviewPanelVisible());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeseriesExplorer.this.setZoomOverviewPanelVisible(TimeseriesExplorer.this.m_MenuItemViewZoomOverview.isSelected());
                }
            });
            this.m_MenuItemViewZoomOverview = menuitem;
            menuitem = new JCheckBoxMenuItem("Anti-aliasing");
            menu.add(menuitem);
            menuitem.setMnemonic('A');
            menuitem.setSelected(this.getTimeseriesPanel().isAntiAliasingEnabled());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeseriesExplorer.this.getTimeseriesPanel().setAntiAliasingEnabled(TimeseriesExplorer.this.m_MenuItemViewAntiAliasing.isSelected());
                }
            });
            this.m_MenuItemViewAntiAliasing = menuitem;
            JMenu submenu = new JMenu("Periodicity");
            menu.add(submenu);
            submenu.setMnemonic('P');
            this.m_MenuItemViewPeriodicity = submenu;
            ButtonGroup group = new ButtonGroup();
            for (final PeriodicityType type : PeriodicityType.values()) {
                menuitem = new JRadioButtonMenuItem(type.toString());
                group.add(menuitem);
                submenu.add(menuitem);
                menuitem.setSelected(type == this.getTimeseriesPanel().getPeriodicityPaintlet().getPeriodicity());
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TimeseriesExplorer.this.getTimeseriesPanel().getPeriodicityPaintlet().setPeriodicity(type);
                        if (TimeseriesExplorer.this.getTimeseriesPanel().getPlot().getAxis(Axis.BOTTOM).getTickGenerator() instanceof PeriodicityTickGenerator) {
                            ((PeriodicityTickGenerator)TimeseriesExplorer.this.getTimeseriesPanel().getPlot().getAxis(Axis.BOTTOM).getTickGenerator()).setPeriodicity(type);
                        }
                        TimeseriesExplorer.this.getTimeseriesPanel().getPlot().getAxis(Axis.BOTTOM).setNumberFormat(PeriodicityHelper.getFormat(type));
                    }
                });
            }
            menuitem = new JMenuItem("Color provider...");
            menu.add(menuitem);
            menuitem.setMnemonic('P');
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeseriesExplorer.this.selectColorProvider();
                }
            });
            this.m_MenuItemViewColorProvider = menuitem;
            this.m_MenuBar = result;
            this.refreshScripts();
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    public void clearData() {
        this.getScriptingEngine().setDatabaseConnection((AbstractDatabaseConnection)DatabaseConnection.getSingleton());
        this.getScriptingEngine().add((BasePanel)this, "clear-data");
    }

    public void loadDataFromDisk() {
        int retVal = this.m_TimeseriesFileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        PlaceholderFile[] files = this.m_TimeseriesFileChooser.getSelectedPlaceholderFiles();
        AbstractDataContainerReader reader = (AbstractDataContainerReader)this.m_TimeseriesFileChooser.getReader();
        for (int i = 0; i < files.length; ++i) {
            reader.setInput(files[i]);
            this.getScriptingEngine().setDatabaseConnection((AbstractDatabaseConnection)DatabaseConnection.getSingleton());
            this.getScriptingEngine().add((BasePanel)this, "add-data-file " + OptionUtils.getCommandLine((Object)reader));
        }
    }

    public void loadDataFromDatabase() {
        if (this.m_DialogSQL == null) {
            this.m_DialogSQL = this.getParentDialog() != null ? new TimeseriesImportDatabaseDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new TimeseriesImportDatabaseDialog(this.getParentFrame(), true);
            this.m_DialogSQL.setDefaultCloseOperation(1);
            this.m_DialogSQL.setTitle("Load timeseries from database");
            this.m_DialogSQL.setSize(800, 600);
        }
        this.m_DialogSQL.setLocationRelativeTo((Component)((Object)this));
        this.m_DialogSQL.setVisible(true);
        if (this.m_DialogSQL.getOption() != 0) {
            return;
        }
        SequenceSource seq = new SequenceSource();
        Properties props = this.m_DialogSQL.getProperties(false);
        adams.flow.standalone.DatabaseConnection dbcon = new adams.flow.standalone.DatabaseConnection();
        dbcon.setURL(props.getProperty("connectionURL"));
        dbcon.setUser(props.getProperty("connectionUser"));
        dbcon.setPassword(props.getPassword("connectionPassword"));
        seq.add((AbstractActor)dbcon);
        String[] ids = props.getProperty("selected").split(",");
        StringConstants sconst = new StringConstants();
        sconst.setStrings((BaseString[])BaseObject.toObjectArray((String[])ids, BaseString.class));
        seq.add((AbstractActor)sconst);
        TimeseriesDbReader reader = new TimeseriesDbReader();
        String query = props.getProperty("queryData", "");
        reader.setSQL(new SQLStatement(query));
        seq.add((AbstractActor)reader);
        TimeseriesReportDbUpdater upd = new TimeseriesReportDbUpdater();
        upd.setLenient(true);
        if (props.getProperty("queryMetaDataKeyValue", "").trim().length() > 0) {
            upd.setQueryType(AbstractReportDbUpdater.QueryType.KEY_VALUE);
            upd.setSQL(new SQLStatement(props.getProperty("queryMetaDataKeyValue")));
            seq.add((AbstractActor)upd);
        } else if (props.getProperty("queryMetaDataRow", "").trim().length() > 0) {
            upd.setQueryType(AbstractReportDbUpdater.QueryType.COLUMN_AS_KEY);
            upd.setSQL(new SQLStatement(props.getProperty("queryMetaDataRow")));
            seq.add((AbstractActor)upd);
        }
        String msg = seq.setUp();
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)msg);
            seq.cleanUp();
            return;
        }
        msg = seq.execute();
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)msg);
            seq.cleanUp();
            return;
        }
        List tokens = seq.getOutputTokens();
        TimeseriesContainerManager manager = this.getContainerManager();
        manager.startUpdate();
        for (Token token : tokens) {
            if (token.getPayload() == null) continue;
            AbstractContainer cont = manager.newContainer((Comparable)((Object)((Timeseries)((Object)token.getPayload()))));
            manager.add(cont);
        }
        manager.finishUpdate();
        ConsolePanel.getSingleton().append(ConsolePanel.OutputType.INFO, "Timeseries from database:\n" + seq.toCommandLine());
    }

    public void close() {
        this.cleanUp();
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
            this.getParentFrame().dispose();
        } else if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
            this.getParentDialog().dispose();
        }
    }

    public void undo() {
        if (!this.m_Undo.canUndo()) {
            return;
        }
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                TimeseriesExplorer.this.showStatus("Performing Undo...");
                TimeseriesExplorer.this.m_Undo.addRedo((Object)TimeseriesExplorer.this.getContainerManager().getAll(), TimeseriesExplorer.this.m_Undo.peekUndoComment());
                Undo.UndoPoint point = TimeseriesExplorer.this.m_Undo.undo();
                List data = (List)point.getData();
                TimeseriesExplorer.this.getContainerManager().startUpdate();
                TimeseriesExplorer.this.getContainerManager().clear();
                TimeseriesExplorer.this.getContainerManager().addAll(data);
                TimeseriesExplorer.this.getContainerManager().finishUpdate();
                return "Done!";
            }

            @Override
            protected void done() {
                super.done();
                TimeseriesExplorer.this.showStatus("");
            }
        };
        worker.execute();
    }

    public void redo() {
        if (!this.m_Undo.canRedo()) {
            return;
        }
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                TimeseriesExplorer.this.showStatus("Performing Redo...");
                TimeseriesExplorer.this.m_Undo.addUndo((Object)TimeseriesExplorer.this.getContainerManager().getAll(), TimeseriesExplorer.this.m_Undo.peekRedoComment(), true);
                Undo.UndoPoint point = TimeseriesExplorer.this.m_Undo.redo();
                List data = (List)point.getData();
                TimeseriesExplorer.this.getContainerManager().startUpdate();
                TimeseriesExplorer.this.getContainerManager().clear();
                TimeseriesExplorer.this.getContainerManager().addAll(data);
                TimeseriesExplorer.this.getContainerManager().finishUpdate();
                return "Done!";
            }

            @Override
            protected void done() {
                super.done();
                TimeseriesExplorer.this.showStatus("");
            }
        };
        worker.execute();
    }

    public void filter() {
        if (this.m_DialogFilter == null) {
            this.m_DialogFilter = this.getParentDialog() != null ? new FilterDialog(this.getParentDialog()) : new FilterDialog(this.getParentFrame());
            this.m_DialogFilter.setFilterListener((FilterListener)this);
        }
        this.m_DialogFilter.setFilter(this.m_CurrentFilter);
        this.m_DialogFilter.setOverlayOriginalData(this.m_FilterOverlayOriginalData);
        this.m_DialogFilter.setLocationRelativeTo((Component)((Object)this));
        this.m_DialogFilter.setVisible(true);
    }

    public void filter(FilterEvent<Timeseries> e) {
        this.m_CurrentFilter = e.getFilter();
        this.m_FilterOverlayOriginalData = e.getOverlayOriginalData();
        if (this.m_FilterOverlayOriginalData) {
            this.getScriptingEngine().add((BasePanel)this, "filter-overlay " + OptionUtils.getCommandLine(this.m_CurrentFilter));
        } else {
            this.getScriptingEngine().add((BasePanel)this, "filter " + OptionUtils.getCommandLine(this.m_CurrentFilter));
        }
    }

    public void setZoomOverviewPanelVisible(boolean value) {
        this.m_PanelTimeseries.setZoomOverviewPanelVisible(value);
    }

    public boolean isZoomOverviewPanelVisible() {
        return this.m_PanelTimeseries.isZoomOverviewPanelVisible();
    }

    protected void selectColorProvider() {
        if (this.m_DialogColorProvider == null) {
            this.m_DialogColorProvider = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_DialogColorProvider.setTitle("Select color provider");
            this.m_DialogColorProvider.getGOEEditor().setClassType(AbstractColorProvider.class);
            this.m_DialogColorProvider.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_DialogColorProvider.setLocationRelativeTo((Component)((Object)this));
        }
        this.m_DialogColorProvider.setCurrent((Object)this.getContainerManager().getColorProvider().shallowCopy());
        this.m_DialogColorProvider.setVisible(true);
        if (this.m_DialogColorProvider.getResult() != 0) {
            return;
        }
        this.getContainerManager().setColorProvider(((AbstractColorProvider)this.m_DialogColorProvider.getCurrent()).shallowCopy());
    }

    public Class[] getSendToClasses() {
        return new Class[]{JComponent.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        return this.getContainerManager().countVisible() > 0;
    }

    public Object getSendToItem(Class[] cls) {
        TimeseriesExplorer result = null;
        if (SendToActionUtils.isAvailable(JComponent.class, (Class[])cls) && this.getContainerManager().countVisible() > 0) {
            result = this;
        }
        return result;
    }

    public void cleanUp() {
        this.m_PanelTimeseries.getContainerManager().removeDataChangeListener((DataChangeListener)this);
        this.m_PanelTimeseries.cleanUp();
        if (this.m_ScriptingDialog != null) {
            this.m_ScriptingDialog.cleanUp();
        }
        if (this.m_DialogSQL != null) {
            this.m_DialogSQL.dispose();
            this.m_DialogSQL = null;
        }
        if (this.m_DialogColorProvider != null) {
            this.m_DialogColorProvider.dispose();
            this.m_DialogColorProvider = null;
        }
    }

    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DatabaseConnection;
    }

    public void setDatabaseConnection(AbstractDatabaseConnection value) {
        this.m_DatabaseConnection = value;
    }

    public void databaseConnectionStateChanged(DatabaseConnectionChangeEvent e) {
        if (e.getType() == DatabaseConnectionChangeEvent.EventType.CONNECT) {
            this.m_DatabaseConnection = e.getDatabaseConnection();
        }
    }
}

