/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.Properties;
import adams.core.base.BasePassword;
import adams.core.net.AbstractSendEmail;
import adams.core.net.EmailAddress;
import adams.core.net.JavaMailSendEmail;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import java.util.ArrayList;
import java.util.Random;

public class EmailHelper {
    public static final String FILENAME = "Email.props";
    public static final String ENABLED = "Enabled";
    public static final String SMTP_SERVER = "SmtpServer";
    public static final String SMTP_PORT = "SmtpPort";
    public static final String SMTP_REQUIRES_AUTHENTICATION = "SmtpRequiresAuthentication";
    public static final String SMTP_START_TLS = "SmtpStartTls";
    public static final String SMTP_USE_SSL = "SmtpUseSsl";
    public static final String SMTP_USER = "SmtpUser";
    public static final String SMTP_PASSWORD = "SmtpPassword";
    public static final String SMTP_TIMEOUT = "SmtpTimeout";
    public static final String DEFAULT_ADDRESS_FROM = "DefaultAddressFrom";
    public static final String DEFAULT_SIGNATURE = "DefaultSignature";
    public static final String DEFAULT_SENDEMAIL = "DefaultSendEmail";
    public static final String SIGNATURE_SEPARATOR = "--";
    protected static Properties m_Properties;

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                m_Properties = Environment.getInstance().read("email");
            }
            catch (Exception e) {
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }

    public static synchronized boolean writeProperties() {
        return EmailHelper.writeProperties(EmailHelper.getProperties());
    }

    public static synchronized boolean writeProperties(Properties props) {
        boolean result = Environment.getInstance().write("email", props);
        m_Properties = null;
        return result;
    }

    public static boolean isEnabled() {
        return EmailHelper.getProperties().getBoolean(ENABLED, Boolean.valueOf(false));
    }

    public static String getSmtpServer() {
        return EmailHelper.getProperties().getProperty(SMTP_SERVER, "somehost");
    }

    public static int getSmtpPort() {
        return EmailHelper.getProperties().getInteger(SMTP_PORT, Integer.valueOf(25));
    }

    public static boolean getSmtpStartTLS() {
        return EmailHelper.getProperties().getBoolean(SMTP_START_TLS, Boolean.valueOf(false));
    }

    public static boolean getSmtpUseSSL() {
        return EmailHelper.getProperties().getBoolean(SMTP_USE_SSL, Boolean.valueOf(false));
    }

    public static boolean getSmtpRequiresAuthentication() {
        return EmailHelper.getProperties().getBoolean(SMTP_REQUIRES_AUTHENTICATION, Boolean.valueOf(false));
    }

    public static int getSmtpTimeout() {
        return EmailHelper.getProperties().getInteger(SMTP_TIMEOUT, Integer.valueOf(30000));
    }

    public static String getSmtpUser() {
        return EmailHelper.getProperties().getProperty(SMTP_USER, "john.doe");
    }

    public static BasePassword getSmtpPassword() {
        return EmailHelper.getProperties().getPassword(SMTP_PASSWORD, new BasePassword("password"));
    }

    public static String getDefaultFromAddress() {
        String result = EmailHelper.getProperties().getProperty(DEFAULT_ADDRESS_FROM, "john.doe@nowhere.org");
        if (result.trim().isEmpty() || !new EmailAddress().isValid(result)) {
            result = "john.doe@nowhere.org";
        }
        return result;
    }

    public static String getDefaultSignature() {
        return EmailHelper.getProperties().getProperty(DEFAULT_SIGNATURE, "");
    }

    public static AbstractSendEmail getDefaultSendEmail() {
        try {
            return (AbstractSendEmail)OptionUtils.forCommandLine(AbstractSendEmail.class, (String)EmailHelper.getProperties().getProperty(DEFAULT_SENDEMAIL, JavaMailSendEmail.class.getName()));
        }
        catch (Exception e) {
            return new JavaMailSendEmail();
        }
    }

    public static String combine(String body, String signature) {
        if (signature == null || signature.trim().length() == 0) {
            return body;
        }
        return body + "\n" + SIGNATURE_SEPARATOR + "\n" + signature;
    }

    public static String createBoundary() {
        Random rand = new Random();
        String result = Integer.toHexString(rand.nextInt()) + Integer.toHexString(rand.nextInt()) + Integer.toHexString(rand.nextInt());
        return result;
    }

    public static String[] breakUp(String s, int columns) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = null;
        if (columns < 1) {
            columns = 1;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (current == null) {
                current = new StringBuilder();
            }
            char c = s.charAt(i);
            current.append(c);
            if (current.length() != columns) continue;
            result.add(current.toString());
            current = null;
        }
        if (current != null) {
            result.add(current.toString());
        }
        return result.toArray(new String[result.size()]);
    }
}

