/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Unknown;
import adams.flow.standalone.FTPConnection;
import adams.flow.transformer.AbstractTransformer;

public class FTPNoOp
extends AbstractTransformer {
    private static final long serialVersionUID = -8492252620858335215L;
    protected FTPConnection m_Connection;

    public String globalInfo() {
        return "Sends a NOOP command to the FTP server whenever a token passes through.";
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Connection = (FTPConnection)ActorUtils.findClosestType((AbstractActor)this, FTPConnection.class);
            if (this.m_Connection == null) {
                result = "No " + FTPConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            if (this.m_Connection.getFTPClient().sendNoOp()) {
                this.m_OutputToken = this.m_InputToken;
            } else {
                result = "NOOP failed!";
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("NOOP failed: ", e);
        }
        return result;
    }
}

