/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Properties;
import adams.core.net.EmailAddress;
import adams.core.net.EmailAddressBook;
import adams.core.net.EmailContact;
import adams.gui.core.BaseTextArea;
import adams.gui.core.ParameterPanelWithButtons;
import adams.gui.core.SearchParameters;
import adams.gui.tools.AbstractManagementPanelWithProperties;
import adams.gui.tools.AbstractManagementTableModel;
import java.awt.Component;
import java.util.List;
import javax.swing.JTextField;

public class EmailAddressBookPanel
extends AbstractManagementPanelWithProperties<EmailContact> {
    private static final long serialVersionUID = 2870352856009767535L;
    protected JTextField m_TextFirstName;
    protected JTextField m_TextLastName;
    protected JTextField m_TextEmail;
    protected BaseTextArea m_TextPhone;
    protected BaseTextArea m_TextAddress;
    protected BaseTextArea m_TextNote;

    protected void addFields(ParameterPanelWithButtons panel) {
        this.m_TextFirstName = new JTextField(30);
        this.addListener(this.m_TextFirstName);
        panel.addParameter("_First", (Component)this.m_TextFirstName);
        this.m_TextLastName = new JTextField(30);
        this.addListener(this.m_TextLastName);
        panel.addParameter("_Last", (Component)this.m_TextLastName);
        this.m_TextEmail = new JTextField(30);
        this.addListener(this.m_TextEmail);
        panel.addParameter("_Email", (Component)this.m_TextEmail);
        this.m_TextPhone = new BaseTextArea(2, 30);
        this.addListener((Component)this.m_TextPhone);
        panel.addParameter("_Phone", (Component)this.m_TextPhone);
        this.m_TextAddress = new BaseTextArea(3, 30);
        this.addListener((Component)this.m_TextAddress);
        panel.addParameter("_Address", (Component)this.m_TextAddress);
        this.m_TextNote = new BaseTextArea(3, 30);
        this.addListener((Component)this.m_TextNote);
        panel.addParameter("_Note", (Component)this.m_TextNote);
    }

    protected synchronized Properties getProperties() {
        return EmailAddressBook.getSingleton().getProperties();
    }

    protected boolean storeProperties() {
        return EmailAddressBook.getSingleton().save();
    }

    protected String createKey(EmailContact value) {
        return EmailAddressBook.createKey(value);
    }

    protected EmailContact fromString(String s) {
        return EmailAddressBook.fromString(s);
    }

    protected String toString(EmailContact value) {
        return EmailAddressBook.toString(value);
    }

    protected AbstractManagementTableModel<EmailContact> newTableModel() {
        return new TableModel();
    }

    protected Class getManagedClass() {
        return EmailContact.class;
    }

    protected void clear() {
        this.m_TextFirstName.setText("");
        this.m_TextLastName.setText("");
        this.m_TextEmail.setText("");
        this.m_TextPhone.setText("");
        this.m_TextAddress.setText("");
        this.m_TextNote.setText("");
    }

    protected EmailContact fieldsToObject() {
        EmailContact result = new EmailContact();
        result.setFirstName(this.m_TextFirstName.getText().trim());
        result.setLastName(this.m_TextLastName.getText().trim());
        result.setEmail(this.m_TextEmail.getText().trim());
        result.setAddress(this.m_TextAddress.getText());
        result.setPhone(this.m_TextPhone.getText());
        result.setNote(this.m_TextNote.getText());
        return result;
    }

    protected void objectToFields(EmailContact value) {
        this.m_TextFirstName.setText(value.getFirstName());
        this.m_TextLastName.setText(value.getLastName());
        this.m_TextEmail.setText(value.getEmail());
        this.m_TextAddress.setText(value.getAddress());
        this.m_TextPhone.setText(value.getPhone());
        this.m_TextNote.setText(value.getNote());
    }

    protected boolean canClearFields() {
        return this.m_TextFirstName.getText().length() > 0 || this.m_TextLastName.getText().length() > 0 || this.m_TextEmail.getText().length() > 0 || this.m_TextAddress.getText().length() > 0 || this.m_TextPhone.getText().length() > 0 || this.m_TextNote.getText().length() > 0;
    }

    protected boolean isReadOnly() {
        return false;
    }

    protected boolean canAddObject() {
        return this.m_TextEmail.getText().trim().length() > 0 && new EmailAddress().isValid(this.m_TextEmail.getText().trim());
    }

    public static class TableModel
    extends AbstractManagementTableModel<EmailContact> {
        private static final long serialVersionUID = 6097860917524908958L;

        public TableModel() {
        }

        public TableModel(List<EmailContact> contacts) {
            super(contacts);
        }

        public TableModel(EmailContact[] contacts) {
            super((Comparable[])contacts);
        }

        public int getColumnCount() {
            return 6;
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return "First";
            }
            if (column == 1) {
                return "Last";
            }
            if (column == 2) {
                return "Email";
            }
            if (column == 3) {
                return "Phone";
            }
            if (column == 4) {
                return "Address";
            }
            if (column == 5) {
                return "Note";
            }
            throw new IllegalArgumentException("Column " + column + " is invalid!");
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            if (columnIndex == 1) {
                return String.class;
            }
            if (columnIndex == 2) {
                return String.class;
            }
            if (columnIndex == 3) {
                return String.class;
            }
            if (columnIndex == 4) {
                return String.class;
            }
            if (columnIndex == 5) {
                return String.class;
            }
            throw new IllegalArgumentException("Column " + columnIndex + " is invalid!");
        }

        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return ((EmailContact)this.m_Values.get(row)).getFirstName();
            }
            if (column == 1) {
                return ((EmailContact)this.m_Values.get(row)).getLastName();
            }
            if (column == 2) {
                return ((EmailContact)this.m_Values.get(row)).getEmail();
            }
            if (column == 3) {
                return ((EmailContact)this.m_Values.get(row)).getPhone();
            }
            if (column == 4) {
                return ((EmailContact)this.m_Values.get(row)).getAddress();
            }
            if (column == 5) {
                return ((EmailContact)this.m_Values.get(row)).getNote();
            }
            throw new IllegalArgumentException("Column " + column + " is invalid!");
        }

        public boolean isSearchMatch(SearchParameters params, int row) {
            if (params.matches(((EmailContact)this.m_Values.get(row)).getEmail())) {
                return true;
            }
            if (params.matches(((EmailContact)this.m_Values.get(row)).getFirstName())) {
                return true;
            }
            if (params.matches(((EmailContact)this.m_Values.get(row)).getLastName())) {
                return true;
            }
            if (params.matches(((EmailContact)this.m_Values.get(row)).getNote())) {
                return true;
            }
            if (params.matches(((EmailContact)this.m_Values.get(row)).getPhone())) {
                return true;
            }
            return params.matches(((EmailContact)this.m_Values.get(row)).getAddress());
        }
    }
}

