/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.gui.core.TextEditorPanel;
import adams.gui.core.dom.DOMTreeWithPreview;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.JComponent;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class HTMLHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = 4859255638148506547L;

    public String globalInfo() {
        return "Displays HTML files: " + Utils.arrayToString((Object)this.getExtensions());
    }

    public String[] getExtensions() {
        return new String[]{"html", "htm"};
    }

    protected PreviewPanel createPreview(File file) {
        PreviewPanel result;
        try {
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new FileInputStream(file.getAbsoluteFile())));
            Document doc = parser.getDocument();
            DOMTreeWithPreview domPanel = new DOMTreeWithPreview();
            domPanel.setDOM((Node)doc);
            domPanel.getTree().expandAll();
            domPanel.setSplitterPosition(500);
            result = new PreviewPanel((JComponent)domPanel);
        }
        catch (Exception e) {
            TextEditorPanel textPanel = new TextEditorPanel();
            textPanel.open(file);
            textPanel.setEditable(false);
            result = new PreviewPanel((JComponent)textPanel, (JComponent)textPanel.getTextArea());
        }
        return result;
    }
}

