/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common.protocol.udp;

import com.turn.ttorrent.common.protocol.TrackerMessage;
import com.turn.ttorrent.common.protocol.udp.UDPTrackerMessage;
import java.nio.ByteBuffer;

public class UDPConnectResponseMessage
extends UDPTrackerMessage.UDPTrackerResponseMessage
implements TrackerMessage.ConnectionResponseMessage {
    private static final int UDP_CONNECT_RESPONSE_MESSAGE_SIZE = 16;
    private final int actionId = TrackerMessage.Type.CONNECT_RESPONSE.getId();
    private final int transactionId;
    private final long connectionId;

    private UDPConnectResponseMessage(ByteBuffer data, int transactionId, long connectionId) {
        super(TrackerMessage.Type.CONNECT_RESPONSE, data);
        this.transactionId = transactionId;
        this.connectionId = connectionId;
    }

    @Override
    public int getActionId() {
        return this.actionId;
    }

    @Override
    public int getTransactionId() {
        return this.transactionId;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public static UDPConnectResponseMessage parse(ByteBuffer data) throws TrackerMessage.MessageValidationException {
        if (data.remaining() != 16) {
            throw new TrackerMessage.MessageValidationException("Invalid connect response message size!");
        }
        if (data.getInt() != TrackerMessage.Type.CONNECT_RESPONSE.getId()) {
            throw new TrackerMessage.MessageValidationException("Invalid action code for connection response!");
        }
        return new UDPConnectResponseMessage(data, data.getInt(), data.getLong());
    }

    public static UDPConnectResponseMessage craft(int transactionId, long connectionId) {
        ByteBuffer data = ByteBuffer.allocate(16);
        data.putInt(TrackerMessage.Type.CONNECT_RESPONSE.getId());
        data.putInt(transactionId);
        data.putLong(connectionId);
        return new UDPConnectResponseMessage(data, transactionId, connectionId);
    }
}

