/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.ClassCache;
import adams.core.StringCompare;
import adams.core.Utils;
import adams.core.logging.ConsoleLoggingObject;
import java.awt.HeadlessException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class ClassLocator
extends ConsoleLoggingObject {
    private static final long serialVersionUID = 6443115424919701746L;
    protected Hashtable<String, List<String>> m_Cache;
    protected HashSet<String> m_BlackListed;
    protected ClassCache m_ClassCache;
    protected static ClassLocator m_Singleton;

    protected ClassLocator() {
        this.initCache();
    }

    public List<String> find(String classname, String[] pkgnames) {
        ArrayList<String> result = new ArrayList();
        try {
            Class<?> cls = Class.forName(classname);
            result = this.find(cls, pkgnames);
        }
        catch (Throwable t) {
            this.getLogger().log(Level.SEVERE, "Failed to instantiate '" + classname + "'/" + Utils.arrayToString(pkgnames) + " (find):", t);
        }
        return result;
    }

    public List<String> find(Class cls, String[] pkgnames) {
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < pkgnames.length; ++i) {
            names.addAll(this.findInPackage(cls, pkgnames[i]));
        }
        result.addAll(names);
        Collections.sort(result, new StringCompare());
        return result;
    }

    public List<String> findInPackage(String classname, String pkgname) {
        ArrayList<String> result = new ArrayList();
        try {
            Class<?> cls = Class.forName(classname);
            result = this.findInPackage(cls, pkgname);
        }
        catch (Throwable t) {
            this.getLogger().log(Level.SEVERE, "Failed to instantiate '" + classname + "'/" + pkgname + " (findInPackage):", t);
        }
        return result;
    }

    public List<String> findInPackage(Class cls, String pkgname) {
        List<String> result = this.getCache(cls, pkgname);
        if (result == null) {
            this.getLogger().info("Searching for '" + cls.getName() + "' in '" + pkgname + "':");
            result = new ArrayList<String>();
            if (this.m_ClassCache.getClassnames(pkgname) != null) {
                result.addAll(this.m_ClassCache.getClassnames(pkgname));
            }
            int i = 0;
            while (i < result.size()) {
                try {
                    if (result.get(i).indexOf(36) > -1) {
                        result.remove(i);
                        continue;
                    }
                    if (this.isBlacklisted(result.get(i))) {
                        result.remove(i);
                        continue;
                    }
                    Class<?> clsNew = Class.forName(result.get(i));
                    if (Modifier.isAbstract(clsNew.getModifiers())) {
                        this.m_ClassCache.remove(result.get(i));
                        result.remove(i);
                        continue;
                    }
                    if (cls.isInterface() && !ClassLocator.hasInterface(cls, clsNew)) {
                        result.remove(i);
                        continue;
                    }
                    if (!cls.isInterface() && !ClassLocator.isSubclass(cls, clsNew)) {
                        result.remove(i);
                        continue;
                    }
                    ++i;
                }
                catch (Throwable t) {
                    if (t.getCause() != null && t.getCause() instanceof HeadlessException) {
                        this.getLogger().warning("Cannot instantiate '" + result.get(i) + "' in headless environment - skipped.");
                    } else {
                        this.getLogger().log(Level.SEVERE, "Failed to instantiate '" + result.get(i) + "' (find):", t);
                    }
                    this.blacklist(result.get(i));
                    result.remove(i);
                }
            }
            Collections.sort(result, new StringCompare());
            this.addCache(cls, pkgname, result);
        }
        return result;
    }

    public List<String> findPackages() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<String> packages = this.m_ClassCache.packages();
        while (packages.hasMoreElements()) {
            result.add(packages.nextElement());
        }
        Collections.sort(result, new StringCompare());
        return result;
    }

    protected void initCache() {
        if (this.m_Cache == null) {
            this.m_Cache = new Hashtable();
        }
        if (this.m_BlackListed == null) {
            this.m_BlackListed = new HashSet();
        }
        if (this.m_ClassCache == null) {
            this.m_ClassCache = new ClassCache();
        }
    }

    protected void addCache(Class cls, String pkgname, List<String> classnames) {
        this.m_Cache.put(cls.getName() + "-" + pkgname, classnames);
    }

    protected List<String> getCache(Class cls, String pkgname) {
        return this.m_Cache.get(cls.getName() + "-" + pkgname);
    }

    protected void blacklist(String classname) {
        this.m_BlackListed.add(classname);
    }

    public boolean isBlacklisted(String classname) {
        return this.m_BlackListed.contains(classname);
    }

    public static synchronized ClassLocator getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new ClassLocator();
        }
        return m_Singleton;
    }

    public static boolean isSubclass(String superclass, String otherclass) {
        try {
            return ClassLocator.isSubclass(Class.forName(superclass), Class.forName(otherclass));
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isSubclass(Class superclass, Class otherclass) {
        boolean result = false;
        Class currentclass = otherclass;
        do {
            result = currentclass.equals(superclass);
            if (currentclass.equals(Object.class) || currentclass.getSuperclass() == null) break;
            if (result) continue;
            currentclass = currentclass.getSuperclass();
        } while (!result);
        return result;
    }

    public static boolean hasInterface(String intf, String cls) {
        try {
            return ClassLocator.hasInterface(Class.forName(intf), Class.forName(cls));
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean hasInterface(Class intf, Class cls) {
        return intf.isAssignableFrom(cls);
    }

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("packages")) {
            List<String> list = ClassLocator.getSingleton().findPackages();
            for (int i = 0; i < list.size(); ++i) {
                System.out.println(list.get(i));
            }
        } else if (args.length == 2) {
            ArrayList<String> packages = new ArrayList<String>();
            StringTokenizer tok = new StringTokenizer(args[1], ",");
            while (tok.hasMoreTokens()) {
                packages.add(tok.nextToken());
            }
            List<String> list = ClassLocator.getSingleton().find(args[0], packages.toArray(new String[packages.size()]));
            System.out.println("Searching for '" + args[0] + "' in '" + args[1] + "':\n" + "  " + list.size() + " found.");
            for (int i = 0; i < list.size(); ++i) {
                System.out.println("  " + (i + 1) + ". " + list.get(i));
            }
        } else {
            System.out.println("\nUsage:");
            System.out.println(ClassLocator.class.getName() + " packages");
            System.out.println("\tlists all packages in the classpath");
            System.out.println(ClassLocator.class.getName() + " <classname> <packagename(s)>");
            System.out.println("\tlists classes derived from/implementing 'classname' that");
            System.out.println("\tcan be found in 'packagename(s)' (comma-separated list)");
            System.out.println();
            System.exit(1);
        }
    }
}

