/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

public class LittleEndian {
    public static boolean isBitSet(byte b, int mask) {
        return (b & mask) > 0;
    }

    public static int bytesToShort(byte[] bytes) {
        assert (bytes.length == 2);
        return (bytes[1] & 0xFF) << 8 | (bytes[0] & 0xFF) << 0;
    }

    public static int bytesToInt(byte[] bytes) {
        assert (bytes.length == 4);
        return (bytes[3] & 0xFF) << 24 | (bytes[2] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | (bytes[0] & 0xFF) << 0;
    }

    public static float bytesToFloat(byte[] bytes) {
        assert (bytes.length == 4);
        return Float.intBitsToFloat((bytes[3] & 0xFF) << 24 | (bytes[2] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | (bytes[0] & 0xFF) << 0);
    }

    public static double bytesToDouble(byte[] bytes) {
        assert (bytes.length == 8);
        return Double.longBitsToDouble(((long)bytes[7] & 0xFFL) << 56 | ((long)bytes[6] & 0xFFL) << 48 | ((long)bytes[5] & 0xFFL) << 40 | ((long)bytes[4] & 0xFFL) << 32 | ((long)bytes[3] & 0xFFL) << 24 | ((long)bytes[2] & 0xFFL) << 16 | ((long)bytes[1] & 0xFFL) << 8 | ((long)bytes[0] & 0xFFL) << 0);
    }

    public static String bytesToString(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < bytes.length && bytes[0] != 0; ++i) {
            result.append((char)bytes[i]);
        }
        return result.toString();
    }
}

