/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.Destroyable;
import adams.core.SerializableObject;
import adams.core.SerializationHelper;
import adams.core.logging.CustomLoggingLevelObject;
import adams.core.option.ArrayProducer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import java.util.HashSet;
import java.util.logging.Level;

public class SerializableObjectHelper
extends CustomLoggingLevelObject
implements Destroyable {
    private static final long serialVersionUID = -6245176175718570463L;
    protected SerializableObject m_Owner;
    protected boolean m_SetupLoadedOrGenerated;
    protected boolean m_Strict;

    public SerializableObjectHelper(SerializableObject owner) {
        this.m_Owner = owner;
        this.m_SetupLoadedOrGenerated = false;
        this.m_Strict = false;
    }

    public SerializableObject getOwner() {
        return this.m_Owner;
    }

    public void reset() {
        this.m_SetupLoadedOrGenerated = false;
    }

    public void setStrict(boolean value) {
        this.m_Strict = value;
        this.reset();
    }

    public boolean isStrict() {
        return this.m_Strict;
    }

    protected String getCommandLine(Object obj) {
        String result;
        if (obj instanceof OptionHandler) {
            HashSet<String> skipped = new HashSet<String>();
            skipped.add("serializationFile");
            skipped.add("overrideSerializedFile");
            ArrayProducer producer = new ArrayProducer();
            producer.setSkippedProperties(skipped);
            producer.produce((OptionHandler)obj);
            result = producer.toString();
            producer.cleanUp();
        } else {
            result = OptionUtils.getCommandLine(obj);
        }
        return result;
    }

    public void loadSetup() {
        if (this.m_SetupLoadedOrGenerated && !this.m_Owner.getOverrideSerializedFile()) {
            return;
        }
        boolean generate = false;
        if (this.m_Owner.getOverrideSerializedFile() || this.m_Owner.getSerializationFile().isDirectory() || !this.m_Owner.getSerializationFile().exists()) {
            generate = true;
            if (this.isLoggingEnabled()) {
                this.getLogger().log(Level.INFO, "m_Owner.getOverrideSerializedFile()=" + this.m_Owner.getOverrideSerializedFile() + ", " + "m_Owner.getSerializationFile().isDirectory()=" + this.m_Owner.getSerializationFile().isDirectory() + ", " + "!m_Owner.getSerializationFile().exists()=" + !this.m_Owner.getSerializationFile().exists() + " --> generate");
            }
        } else {
            Object[] fullSetup = null;
            try {
                fullSetup = SerializationHelper.readAll(this.m_Owner.getSerializationFile().getAbsolutePath());
            }
            catch (Exception e) {
                fullSetup = null;
                this.getLogger().log(Level.SEVERE, "Error deserializing from '" + this.m_Owner.getSerializationFile() + "'!", e);
            }
            if (fullSetup == null) {
                generate = true;
            } else {
                String options;
                Object[] setup = new Object[fullSetup.length - 1];
                if (fullSetup.length > 1) {
                    System.arraycopy(fullSetup, 1, setup, 0, fullSetup.length - 1);
                }
                if (!(options = (String)fullSetup[0]).equals(this.getCommandLine(this.m_Owner))) {
                    generate = this.m_Strict;
                    if (this.isLoggingEnabled()) {
                        if (this.m_Strict) {
                            this.getLogger().log(Level.SEVERE, "Options differ --> generate");
                        } else {
                            this.getLogger().log(Level.WARNING, "Options differ");
                        }
                    }
                } else {
                    this.m_Owner.setSerializationSetup(setup);
                    this.m_SetupLoadedOrGenerated = true;
                }
            }
        }
        if (generate) {
            this.generateSetup();
            if (!this.m_Owner.getSerializationFile().isDirectory()) {
                this.saveSetup();
                if (this.isLoggingEnabled()) {
                    this.getLogger().log(Level.INFO, "Serializing setup: " + this.m_Owner.getSerializationFile());
                }
            }
            this.m_SetupLoadedOrGenerated = true;
        }
    }

    public void saveSetup() {
        if (this.m_Owner.getSerializationFile().isDirectory()) {
            return;
        }
        try {
            Object[] setup = this.m_Owner.retrieveSerializationSetup();
            Object[] fullSetup = new Object[setup.length + 1];
            fullSetup[0] = this.getCommandLine(this.m_Owner);
            if (setup.length > 0) {
                System.arraycopy(setup, 0, fullSetup, 1, setup.length);
            }
            SerializationHelper.writeAll(this.m_Owner.getSerializationFile().getAbsolutePath(), fullSetup);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error serializing to '" + this.m_Owner.getSerializationFile() + "'!", e);
        }
    }

    public void generateSetup() {
        this.m_Owner.initSerializationSetup();
    }

    public String toString() {
        String result = "Owner=" + this.m_Owner.getClass().getName() + ", " + "File=" + this.m_Owner.getSerializationFile() + ", " + "IsDirectory=" + this.m_Owner.getSerializationFile().isDirectory() + ", " + "Override=" + this.m_Owner.getOverrideSerializedFile();
        return result;
    }

    @Override
    public void destroy() {
        this.reset();
        this.m_Owner = null;
    }
}

