/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.Utils;
import adams.core.base.AbstractBaseString;
import java.awt.Dimension;

public class BaseDimension
extends AbstractBaseString {
    private static final long serialVersionUID = -3504062141216626521L;
    public static final String SEPARATOR = ";";
    public static final String DEFAULT = "0;0";

    public BaseDimension() {
        this(DEFAULT);
    }

    public BaseDimension(String s) {
        super(s);
    }

    public BaseDimension(Dimension value) {
        this(BaseDimension.toString(value));
    }

    public BaseDimension(int width, int height) {
        this(new Dimension(width, height));
    }

    @Override
    protected void initialize() {
        this.m_Internal = DEFAULT;
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        return this.parse(value) != null;
    }

    public Dimension dimensionValue() {
        return this.parse((String)((Object)this.m_Internal));
    }

    @Override
    public String getTipText() {
        return "A dimension (width;height).";
    }

    public static String toString(Dimension d) {
        return d.width + SEPARATOR + d.height;
    }

    public Dimension parse(String s) {
        String[] parts;
        Dimension result = null;
        if (s.indexOf(SEPARATOR) > 0 && (parts = s.split(SEPARATOR)).length == 2 && Utils.isInteger(parts[0]) && Utils.isInteger(parts[1])) {
            result = new Dimension(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
        }
        return result;
    }
}

