/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.DateFormat;
import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.io.SimpleFilenameGenerator;
import adams.core.option.OptionHandler;
import adams.data.DateFormatString;
import java.io.File;
import java.util.Date;

public class TimestampFilenameGenerator
extends SimpleFilenameGenerator {
    private static final long serialVersionUID = 4586559227363230335L;
    protected DateFormatString m_Format;
    protected transient DateFormat m_Formatter;

    @Override
    public String globalInfo() {
        return "Generator that assembles a filename based on output dir, prefix, current timestamp (according to format string), suffix and extension.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("format", "format", this.getDefaultFormat());
    }

    protected synchronized DateFormat getFormatter() {
        if (this.m_Formatter == null) {
            this.m_Formatter = this.m_Format.toDateFormat();
        }
        return this.m_Formatter;
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "format", !this.m_Format.isEmpty() ? this.m_Format.getValue() : null);
    }

    protected DateFormatString getDefaultFormat() {
        return new DateFormatString("yyyy-MM-dd HH:mm:ss");
    }

    public void setFormat(DateFormatString value) {
        this.m_Format = value;
        this.reset();
    }

    public DateFormatString getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The format of the timestamp to generate.";
    }

    @Override
    protected String doGenerate(Object obj) {
        return new PlaceholderFile(this.m_Directory.getAbsolutePath() + File.separator + this.m_Prefix + this.getFormatter().format(new Date()) + this.m_Suffix + this.m_Extension).getAbsolutePath();
    }
}

