/*
 * Decompiled with CFR 0.152.
 */
package adams.core.management;

import adams.core.ClassLocator;
import adams.core.Utils;
import adams.core.logging.LoggingObject;
import adams.core.management.AbstractOutputPrinter;
import adams.core.management.ClassPathAugmenter;
import adams.core.management.DefaultOutputPrinter;
import adams.core.management.Java;
import adams.core.management.LoggingObjectOwner;
import adams.core.management.OS;
import adams.core.management.OutputProcessStream;
import adams.core.management.RestartableApplication;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.gui.core.GUIHelper;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Launcher {
    public static final int CODE_RESTART = 100;
    public static final int CODE_RESTART_MORE_HEAP = 101;
    public static final String ENV_ADAMS_OPTS = "ADAMS_OPTS";
    protected String m_Memory = "";
    protected String m_MainClass = "";
    protected String m_JavaAgentJar = "";
    protected List<String> m_JVMOptions = new ArrayList<String>();
    protected List<String> m_ClassPathAugmentations;
    protected String[] m_Arguments = new String[0];
    protected Runtime m_Runtime = Runtime.getRuntime();
    protected Process m_Process;
    protected int m_DebugLevel = 0;
    protected boolean m_IgnoreEnvironmentOptions = false;
    protected boolean m_SuppressErrorDialog = false;
    protected Class m_OutputPrinter = DefaultOutputPrinter.class;
    protected OutputProcessStream m_StdOut;
    protected OutputProcessStream m_StdErr;
    protected LoggingObject m_ConsoleObject = null;

    public Launcher() {
        this.m_ClassPathAugmentations = new ArrayList<String>();
    }

    public String setMemory(String value) {
        String result = null;
        if ((value = value.trim().toLowerCase()).endsWith("k") || value.endsWith("m") || value.endsWith("g")) {
            try {
                Integer.parseInt(value.substring(0, value.length() - 1));
                this.m_Memory = value;
            }
            catch (Exception e) {
                result = "Failed to parse '" + value + "': " + e;
            }
        } else {
            result = "Memory amount must end with one of the following quantifiers: k, m, g";
        }
        return result;
    }

    public String setDebugLevel(String value) {
        String result = null;
        try {
            this.m_DebugLevel = Integer.parseInt(value);
        }
        catch (Exception e) {
            result = "Failed to parse debug level '" + value + "': " + e;
        }
        return result;
    }

    protected void increaseHeap() {
        String suffix = "";
        for (int i = this.m_Memory.length() - 1; i >= 0 && (this.m_Memory.charAt(i) < '0' || this.m_Memory.charAt(i) > '9'); --i) {
            suffix = this.m_Memory.charAt(i) + suffix;
        }
        String amount = this.m_Memory.substring(0, this.m_Memory.length() - suffix.length());
        double factor = 1.5;
        if (suffix.toLowerCase().equals("g")) {
            suffix = "m";
            factor = 1500.0;
        }
        this.m_Memory = (long)((double)Long.parseLong(amount) * factor) + suffix;
    }

    public String setMainClass(String value) {
        String result = null;
        try {
            Class.forName(value);
            this.m_MainClass = value;
        }
        catch (Exception e) {
            result = "Class not found: " + value;
        }
        return result;
    }

    public String setJavaAgentJar(String value) {
        String result = null;
        try {
            File file = new File(value);
            if (file.exists() && file.isFile()) {
                this.m_JavaAgentJar = value;
            }
        }
        catch (Exception e) {
            result = "Java agent jar not found or not a file: " + value;
        }
        return result;
    }

    public void addJVMOption(String value) {
        this.m_JVMOptions.add(value);
    }

    public void addClassPathAugmentations(String cmdline) {
        try {
            ClassPathAugmenter augmenter = (ClassPathAugmenter)((Object)OptionUtils.forCommandLine(ClassPathAugmenter.class, cmdline));
            String[] augmentations = augmenter.getClassPathAugmentation();
            this.m_ClassPathAugmentations.addAll(Arrays.asList(augmentations));
        }
        catch (Exception e) {
            System.err.println("Error using classpath augmenter '" + cmdline + "':");
            e.printStackTrace();
        }
    }

    public void addClassPathAugmentations(ClassPathAugmenter augmenter) {
        this.m_ClassPathAugmentations.addAll(Arrays.asList(augmenter.getClassPathAugmentation()));
    }

    public String setArguments(String[] value) {
        String result = null;
        try {
            this.m_Arguments = OptionUtils.splitOptions(OptionUtils.joinOptions(value));
        }
        catch (Exception e) {
            result = "Failed to parse the arguments: " + e;
        }
        return result;
    }

    public void addShutdownHook() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (Launcher.this.m_Process != null) {
                    Launcher.this.m_Process.destroy();
                }
            }
        };
        this.m_Runtime.addShutdownHook(thread);
    }

    public void ignoreEnvironmentOptions() {
        this.m_IgnoreEnvironmentOptions = true;
    }

    public void suppressErrorDialog() {
        this.m_SuppressErrorDialog = true;
    }

    public void setOutputPrinter(Class cls) {
        if (!ClassLocator.isSubclass(AbstractOutputPrinter.class, cls)) {
            throw new IllegalArgumentException("Class is not derived from " + AbstractOutputPrinter.class.getName() + ": " + cls.getName());
        }
        this.m_OutputPrinter = cls;
    }

    public void setConsoleObject(LoggingObject owner) {
        this.m_ConsoleObject = owner;
    }

    protected String getClassPath() {
        StringBuilder result = new StringBuilder(System.getProperty("java.class.path"));
        String sep = System.getProperty("path.separator");
        String os = OS.isMac() ? "macosx" : (OS.isWindows() ? "windows" : "linux");
        os = os + OS.getBitness();
        String[] parts = System.getProperty("java.class.path").split(sep);
        for (String part : parts) {
            String[] jars;
            File file = new File(part);
            if (file.isFile()) {
                file = file.getParentFile();
            }
            if (!(file = new File(file.getAbsolutePath() + File.separator + os)).exists() || !file.isDirectory()) continue;
            for (String jar : jars = file.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            })) {
                if (result.length() > 0) {
                    result.append(sep);
                }
                result.append(file.getAbsolutePath() + File.separator + jar);
            }
            break;
        }
        for (String augmentation : this.m_ClassPathAugmentations) {
            if (result.length() > 0) {
                result.append(sep);
            }
            result.append(augmentation);
        }
        return result.toString();
    }

    public OutputProcessStream getStdOut() {
        return this.m_StdOut;
    }

    public OutputProcessStream getStdErr() {
        return this.m_StdErr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        String result = null;
        boolean enableRestart = false;
        try {
            if (ClassLocator.hasInterface(RestartableApplication.class, Class.forName(this.m_MainClass))) {
                enableRestart = true;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to instantiate class '" + this.m_MainClass + "'!");
            e.printStackTrace();
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(Java.getJavaExecutable());
        cmd.add("-Xmx" + this.m_Memory);
        cmd.addAll(this.m_JVMOptions);
        cmd.add("-classpath");
        cmd.add(this.getClassPath());
        if (this.m_JavaAgentJar.length() > 0) {
            cmd.add("-javaagent:" + this.m_JavaAgentJar);
        }
        cmd.add(this.m_MainClass);
        if (enableRestart) {
            cmd.add("-enable-restart");
        }
        cmd.addAll(Arrays.asList(this.m_Arguments));
        if (!this.m_IgnoreEnvironmentOptions && System.getenv(ENV_ADAMS_OPTS) != null) {
            try {
                cmd.addAll(Arrays.asList(OptionUtils.splitOptions(System.getenv(ENV_ADAMS_OPTS))));
            }
            catch (Exception e) {
                System.err.println("Error parsing environment variable 'ADAMS_OPTS':");
                e.printStackTrace();
            }
        }
        try {
            Launcher e;
            if (this.m_DebugLevel > 1) {
                System.out.println("Generated command-line: " + Utils.flatten(cmd, " "));
            }
            this.m_Process = this.m_Runtime.exec(cmd.toArray(new String[cmd.size()]), null, new File(System.getProperty("basedir", ".")));
            this.m_StdOut = new OutputProcessStream(this.m_Process, this.m_OutputPrinter, true);
            this.m_StdErr = new OutputProcessStream(this.m_Process, this.m_OutputPrinter, false);
            if (this.m_ConsoleObject != null) {
                if (this.m_StdOut.getPrinter() instanceof LoggingObjectOwner) {
                    ((LoggingObjectOwner)((Object)this.m_StdOut.getPrinter())).setOwner(this.m_ConsoleObject);
                }
                if (this.m_StdErr.getPrinter() instanceof LoggingObjectOwner) {
                    ((LoggingObjectOwner)((Object)this.m_StdErr.getPrinter())).setOwner(this.m_ConsoleObject);
                }
            }
            Thread thStdOut = new Thread(this.m_StdOut);
            Thread thStdErr = new Thread(this.m_StdErr);
            thStdOut.start();
            thStdErr.start();
            int retVal = this.m_Process.waitFor();
            if (this.m_DebugLevel > 0) {
                System.out.println("Exit code: " + retVal);
            }
            if (retVal != 0) {
                result = "Exit code=" + retVal;
            }
            while (thStdOut.isAlive()) {
                try {
                    e = this;
                    synchronized (e) {
                        this.wait(50L);
                    }
                }
                catch (Exception e2) {
                }
            }
            while (thStdErr.isAlive()) {
                try {
                    e = this;
                    synchronized (e) {
                        this.wait(50L);
                    }
                }
                catch (Exception e3) {
                }
            }
            if (retVal == 100) {
                return this.execute();
            }
            if (retVal == 101) {
                this.increaseHeap();
                return this.execute();
            }
            if (retVal != 0) {
                String msg = "Application exited unexpected with exit code " + retVal + ", " + "options used for starting process:\n\n" + Utils.flatten(cmd, "\n");
                System.err.println(msg);
                if (!this.m_SuppressErrorDialog && !GraphicsEnvironment.isHeadless()) {
                    GUIHelper.showErrorMessage(null, msg, "Application exited unexpected!");
                }
            }
        }
        catch (Exception e) {
            result = "Exception occurred launching " + this.m_MainClass + ": ";
            System.err.println(result);
            e.printStackTrace();
            result = result + e;
        }
        return result;
    }

    protected static String configure(String[] args, Launcher launcher) {
        String result = null;
        ArrayList<String> options = new ArrayList<String>(Arrays.asList(args));
        String value = OptionUtils.removeOption(options, "-debug");
        if (value != null) {
            result = launcher.setDebugLevel(value);
        }
        if ((result = (value = OptionUtils.removeOption(options, "-memory")) != null ? launcher.setMemory(value) : "Missing option: -memory") == null) {
            value = OptionUtils.removeOption(options, "-main");
            result = value != null ? launcher.setMainClass(value) : "Missing option: -main";
        }
        if (result == null && (value = OptionUtils.removeOption(options, "-javaagent")) != null) {
            result = launcher.setJavaAgentJar(value);
        }
        if (result == null) {
            while ((value = OptionUtils.removeOption(options, "-jvm")) != null) {
                launcher.addJVMOption(value);
            }
        }
        if (result == null) {
            while ((value = OptionUtils.removeOption(options, "-cpa")) != null) {
                launcher.addClassPathAugmentations(value);
            }
        }
        if (result == null) {
            result = launcher.setArguments(options.toArray(new String[options.size()]));
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        if (OptionUtils.helpRequested(args)) {
            System.out.println("Options:");
            System.out.println("-debug <level>");
            System.out.println("\tThe debug level with 0=off and the higher the number");
            System.out.println("\tthe more output (optional parameter; default: 0).");
            System.out.println("-memory <amount>");
            System.out.println("\tSpecifies the maximum amount of memory to allocate for");
            System.out.println("\tthe heap in the JVM for the process that is being launch.");
            System.out.println("\tUse 'k' for kilobytes, 'm' for megabytes and 'g' for ");
            System.out.println("\tgigabytes. Examples: 1000m, 2g");
            System.out.println("-main <classname>");
            System.out.println("\tThe class to launch as main class in the new JVM process.");
            System.out.println("-javaagent <jar-file>");
            System.out.println("\tThe jar file containing the Java Agent.");
            System.out.println("\tExample: -javaagent /some/where/sizeofag-1.0.0.jar).");
            System.out.println("[-jvm <option>]");
            System.out.println("\tOptional arguments for the JVM.");
            System.out.println("\tExample: -jvm -javaagent:sizeofag.jar");
            System.out.println("[-cpa <classname>]");
            System.out.println("\tOptional classpath augmenters (classname + options).");
            System.out.println("\tExample: -cpa adams.core.management.SystemClassPathAugmenter");
            System.out.println("-...");
            System.out.println("\tAny other option will get passed on to the main class.");
            return;
        }
        Environment.setEnvironmentClass(Environment.class);
        Launcher launcher = new Launcher();
        String error = Launcher.configure(args, launcher);
        if (error == null) {
            launcher.addShutdownHook();
            launcher.execute();
        } else {
            System.err.println("Failed to execute launcher:");
            System.err.println(error);
            System.exit(1);
        }
    }
}

