/*
 * Decompiled with CFR 0.152.
 */
package adams.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class SortedList<T>
implements List<T>,
Serializable,
Cloneable {
    private static final long serialVersionUID = -6982960827830177434L;
    protected ArrayList<T> m_List;
    protected Comparator m_Comparator;
    protected static Comparator m_DefaultComparator = new DefaultComparator();

    public SortedList() {
        this.m_List = new ArrayList();
        this.m_Comparator = m_DefaultComparator;
    }

    public SortedList(Comparator comp) {
        this.m_List = new ArrayList();
        this.m_Comparator = comp;
    }

    public SortedList(int initialCapacity) {
        this.m_List = new ArrayList(initialCapacity);
        this.m_Comparator = m_DefaultComparator;
    }

    public SortedList(int initialCapacity, Comparator comp) {
        this.m_List = new ArrayList(initialCapacity);
        this.m_Comparator = comp;
    }

    public SortedList(Collection<? extends T> c) {
        this.m_List = new ArrayList<T>(c);
        this.m_Comparator = m_DefaultComparator;
        this.sort();
    }

    public SortedList(Collection<? extends T> c, Comparator comp) {
        this.m_List = new ArrayList<T>(c);
        this.m_Comparator = comp;
        this.sort();
    }

    public Comparator getComparator() {
        return this.m_Comparator;
    }

    protected void sort() {
        Collections.sort(this.m_List, this.m_Comparator);
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        return new SortedList<T>(this.m_List, this.m_Comparator);
    }

    @Override
    public synchronized int size() {
        return this.m_List.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.m_List.isEmpty();
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.m_List.contains(o);
    }

    @Override
    public synchronized Iterator<T> iterator() {
        return this.m_List.iterator();
    }

    @Override
    public synchronized Object[] toArray() {
        return this.m_List.toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        return this.m_List.toArray(a);
    }

    @Override
    public synchronized boolean add(T e) {
        boolean result;
        int index = Collections.binarySearch(this.m_List, e, this.m_Comparator);
        if (index < 0) {
            this.m_List.add(-index - 1, e);
            result = true;
        } else {
            this.m_List.add(index, e);
            result = true;
        }
        return result;
    }

    @Override
    public synchronized boolean remove(Object o) {
        return this.m_List.remove(o);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        return this.m_List.containsAll(c);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends T> c) {
        boolean result = false;
        this.m_List.ensureCapacity(this.size() + c.size());
        for (T element : c) {
            int index = Collections.binarySearch(this.m_List, element, this.m_Comparator);
            if (index < 0) {
                this.m_List.add(-index - 1, element);
                result = true;
                continue;
            }
            this.m_List.add(index, element);
            result = true;
        }
        return result;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        return this.m_List.removeAll(c);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        return this.m_List.retainAll(c);
    }

    @Override
    public synchronized void clear() {
        this.m_List.clear();
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends T> c) {
        boolean result = this.m_List.addAll(index, c);
        this.sort();
        return result;
    }

    @Override
    public synchronized T get(int index) {
        return this.m_List.get(index);
    }

    @Override
    public synchronized T set(int index, T element) {
        T result = this.m_List.set(index, element);
        this.sort();
        return result;
    }

    @Override
    public synchronized void add(int index, T element) {
        this.m_List.add(index, element);
        this.sort();
    }

    @Override
    public synchronized T remove(int index) {
        return this.m_List.remove(index);
    }

    @Override
    public synchronized int indexOf(Object o) {
        int result = Collections.binarySearch(this.m_List, o, this.m_Comparator);
        if (result < 0) {
            result = -1;
        }
        return result;
    }

    @Override
    public synchronized int lastIndexOf(Object o) {
        return this.m_List.lastIndexOf(o);
    }

    @Override
    public synchronized ListIterator<T> listIterator() {
        return this.m_List.listIterator();
    }

    @Override
    public synchronized ListIterator<T> listIterator(int index) {
        return this.m_List.listIterator(index);
    }

    @Override
    public synchronized List<T> subList(int fromIndex, int toIndex) {
        SortedList<T> result = new SortedList<T>();
        result.m_Comparator = this.m_Comparator;
        result.m_List.addAll(this.m_List.subList(fromIndex, toIndex));
        return result;
    }

    @Override
    public synchronized int hashCode() {
        return this.m_List.hashCode();
    }

    public synchronized String toString() {
        return this.m_List.toString();
    }

    public static class DefaultComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = -4121107272578264484L;

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo((Comparable)o2);
        }
    }
}

