/*
 * Decompiled with CFR 0.152.
 */
package adams.data.baseline;

import adams.data.baseline.AbstractBaselineCorrection;
import adams.data.baseline.AbstractDatabaseConnectionBaselineCorrection;
import adams.data.container.DataContainer;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionHandler;

public class NamedSetup<T extends DataContainer>
extends AbstractDatabaseConnectionBaselineCorrection<T> {
    private static final long serialVersionUID = -7461880253377745975L;
    protected adams.core.NamedSetup m_Setup;
    protected AbstractBaselineCorrection<T> m_ActualScheme;

    @Override
    public String globalInfo() {
        return "Applies a baseline correction scheme that is referenced via its global setup name (see 'NamedSetups').";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("setup", "setup", new adams.core.NamedSetup());
    }

    @Override
    public void reset() {
        super.reset();
        this.m_ActualScheme = null;
    }

    @Override
    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    public void setSetup(adams.core.NamedSetup value) {
        this.m_Setup = value;
        if (!this.m_Setup.isDummy() && !this.m_Setup.exists()) {
            this.getLogger().severe("Warning: named setup '" + this.m_Setup + "' unknown!");
        }
        this.reset();
    }

    public adams.core.NamedSetup getSetup() {
        return this.m_Setup;
    }

    public String setupTipText() {
        return "The name of the setup to use.";
    }

    protected AbstractBaselineCorrection getActualScheme() {
        if (this.m_ActualScheme == null) {
            this.m_ActualScheme = (AbstractBaselineCorrection)this.m_Setup.getSetup();
            if (this.m_ActualScheme == null) {
                throw new IllegalStateException("Failed to instantiate named setup '" + this.m_Setup + "'!");
            }
            if (this.m_ActualScheme instanceof DatabaseConnectionHandler) {
                ((DatabaseConnectionHandler)((Object)this.m_ActualScheme)).setDatabaseConnection(this.getDatabaseConnection());
            }
        }
        return this.m_ActualScheme;
    }

    @Override
    protected T processData(T data) {
        return this.getActualScheme().correct(data);
    }
}

