/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.blob.BlobContainer;
import adams.data.conversion.AbstractConversion;

public class ByteArrayToBlobContainer
extends AbstractConversion {
    private static final long serialVersionUID = 8828591710515484463L;
    protected String m_ID;

    @Override
    public String globalInfo() {
        return "Wraps the byte array in a " + BlobContainer.class.getName() + ", " + "which allows the storage of meta-data using the attached report " + "and/or notes.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("id", "ID", "");
    }

    public void setID(String value) {
        this.m_ID = value;
        this.reset();
    }

    public String getID() {
        return this.m_ID;
    }

    public String IDTipText() {
        return "The ID to give to the container.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "ID", this.m_ID.isEmpty() ? "-none-" : this.m_ID, "id: ");
    }

    @Override
    public Class accepts() {
        return byte[].class;
    }

    @Override
    public Class generates() {
        return BlobContainer.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        byte[] input = (byte[])this.m_Input;
        BlobContainer result = new BlobContainer();
        result.setID(this.m_ID);
        result.setContent(input);
        return result;
    }
}

