/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractStringConversion;

public class LeftPad
extends AbstractStringConversion {
    private static final long serialVersionUID = -9142177169642814841L;
    protected int m_Width;
    protected String m_PadCharacter;

    @Override
    public String globalInfo() {
        return "Left pads a string up to a maximum number of characters.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", 0, 0, null);
        this.m_OptionManager.add("pad-char", "padCharacter", "0");
    }

    public void setWidth(int value) {
        if (value >= 0) {
            this.m_Width = value;
            this.reset();
        } else {
            System.err.println("Width cannot be negative!");
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The maximum width of the padded string.";
    }

    public void setPadCharacter(String value) {
        if (value.length() == 1) {
            this.m_PadCharacter = value;
            this.reset();
        } else {
            System.err.println("Only single character allowed!");
        }
    }

    public String getPadCharacter() {
        return this.m_PadCharacter;
    }

    public String padCharacterTipText() {
        return "The character to pad with.";
    }

    @Override
    protected Object doConvert() throws Exception {
        StringBuilder result = new StringBuilder((String)this.m_Input);
        while (result.length() < this.m_Width) {
            result.insert(0, this.m_PadCharacter);
        }
        return result.toString();
    }
}

