/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Utils;
import adams.data.conversion.AbstractConversion;
import adams.flow.core.Unknown;

public class ObjectArrayToPrimitiveArray
extends AbstractConversion {
    private static final long serialVersionUID = 7012073882235453335L;

    @Override
    public String globalInfo() {
        return "Converts an object array to its primitive counterpart.";
    }

    @Override
    public Class accepts() {
        return Unknown.class;
    }

    @Override
    public Class generates() {
        return Unknown.class;
    }

    protected byte[] convert(Byte[] array) {
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    protected short[] convert(Short[] array) {
        short[] result = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    protected int[] convert(Integer[] array) {
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    protected long[] convert(Long[] array) {
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    protected float[] convert(Float[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].floatValue();
        }
        return result;
    }

    protected double[] convert(Double[] array) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    protected char[] convert(Character[] array) {
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].charValue();
        }
        return result;
    }

    @Override
    protected Object doConvert() throws Exception {
        if (this.m_Input instanceof Byte[]) {
            return this.convert((Byte[])this.m_Input);
        }
        if (this.m_Input instanceof Integer[]) {
            return this.convert((Integer[])this.m_Input);
        }
        if (this.m_Input instanceof Long[]) {
            return this.convert((Long[])this.m_Input);
        }
        if (this.m_Input instanceof Double[]) {
            return this.convert((Double[])this.m_Input);
        }
        if (this.m_Input instanceof Float[]) {
            return this.convert((Float[])this.m_Input);
        }
        if (this.m_Input instanceof Short[]) {
            return this.convert((Short[])this.m_Input);
        }
        if (this.m_Input instanceof Character[]) {
            return this.convert((Character[])this.m_Input);
        }
        this.getLogger().warning("Failed to convert array: " + Utils.classToString(this.m_Input.getClass()));
        return this.m_Input;
    }
}

