/*
 * Decompiled with CFR 0.152.
 */
package adams.data.featureconverter;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.featureconverter.AbstractFeatureConverter;
import adams.data.featureconverter.AbstractMetaFeatureConverter;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.featureconverter.Text;
import adams.data.report.DataType;
import java.util.ArrayList;
import java.util.List;

public class FixedNumFeatures
extends AbstractMetaFeatureConverter {
    private static final long serialVersionUID = -5349388859224578387L;
    protected int m_NumFeatures;
    protected String m_HeaderTemplate;
    protected FillerType m_FillerType;
    protected double m_FillerNumeric;
    protected String m_FillerString;
    protected boolean m_FillerBoolean;

    @Override
    public String globalInfo() {
        return "Meta-feature-converter that ensures that the generated output has a fixed number of data points.\nIn case of filler type " + (Object)((Object)FillerType.FIRST_VALUE) + ", the data gets " + "inserted at the start, as opposed to at the end when using " + (Object)((Object)FillerType.LAST_VALUE) + ".\n" + (Object)((Object)FillerType.FILLER_NUMERIC) + "/" + (Object)((Object)FillerType.FILLER_STRING) + "/" + (Object)((Object)FillerType.FILLER_BOOLEAN) + " " + "use the appropriate filler value that the user specified.\n" + "The MISSING_* types just add a missing value of the appropriate data type.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-features", "numFeatures", 1, 1, null);
        this.m_OptionManager.add("header-template", "headerTemplate", "Filler-#");
        this.m_OptionManager.add("filler-type", "fillerType", (Object)FillerType.MISSING_NUMERIC);
        this.m_OptionManager.add("filler-numeric", "fillerNumeric", 0.0);
        this.m_OptionManager.add("filler-string", "fillerString", "");
        this.m_OptionManager.add("filler-boolean", "fillerBoolean", false);
    }

    @Override
    protected AbstractFeatureConverter getDefaultConverter() {
        return new Text();
    }

    public void setNumFeatures(int value) {
        if (value >= 1) {
            this.m_NumFeatures = value;
            this.reset();
        } else {
            this.getLogger().warning("At least 1 feature must be present, provided: " + value);
        }
    }

    public int getNumFeatures() {
        return this.m_NumFeatures;
    }

    public String numFeaturesTipText() {
        return "The number of features to ensure, either trim or fill to satisfy.";
    }

    public void setHeaderTemplate(String value) {
        this.m_HeaderTemplate = value;
        this.reset();
    }

    public String getHeaderTemplate() {
        return this.m_HeaderTemplate;
    }

    public String headerTemplateTipText() {
        return "The template for filling in the header; '#' is 1-based index for filled in value, '$' is 1-based, absolute column index; Using a header definition of 'Att-1,Att-2,Att-3' with a size of 5 will give you: 'Filler-#' -> 'Att-1,Att-2,Att-3,Filler-1,Fillter-2', 'Filler-$' -> 'Att-1,Att-2,Att-3,Filler-4,Filler-5'";
    }

    public void setFillerType(FillerType value) {
        this.m_FillerType = value;
        this.reset();
    }

    public FillerType getFillerType() {
        return this.m_FillerType;
    }

    public String fillerTypeTipText() {
        return "The type of filler to use.";
    }

    public void setFillerNumeric(double value) {
        this.m_FillerNumeric = value;
        this.reset();
    }

    public double getFillerNumeric() {
        return this.m_FillerNumeric;
    }

    public String fillerNumericTipText() {
        return "The value for a numeric filler.";
    }

    public void setFillerString(String value) {
        this.m_FillerString = value;
        this.reset();
    }

    public String getFillerString() {
        return this.m_FillerString;
    }

    public String fillerStringTipText() {
        return "The value for a string filler.";
    }

    public void setFillerBoolean(boolean value) {
        this.m_FillerBoolean = value;
        this.reset();
    }

    public boolean getFillerBoolean() {
        return this.m_FillerBoolean;
    }

    public String fillerBooleanTipText() {
        return "The value for a boolean filler.";
    }

    @Override
    public String converterTipText() {
        return "The base feature converter to use and trim to size or extend.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "numFeatures", this.m_NumFeatures, "# features: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "fillerType", (Object)this.m_FillerType, ", filler: ");
        result = result + ", " + super.getQuickInfo();
        return result;
    }

    @Override
    public Class getDatasetFormat() {
        return this.m_Converter.getDatasetFormat();
    }

    @Override
    public Class getRowFormat() {
        return this.m_Converter.getRowFormat();
    }

    protected Object doGenerateHeader(HeaderDefinition header) {
        HeaderDefinition fixed = header.getClone();
        while (fixed.size() > this.m_NumFeatures) {
            if (this.m_FillerType == FillerType.FIRST_VALUE) {
                fixed.remove(0);
                continue;
            }
            fixed.remove(fixed.size() - 1);
        }
        int count = 0;
        block8: while (fixed.size() < this.m_NumFeatures) {
            String name = this.m_HeaderTemplate.replace("#", "" + ++count).replace("$", "" + (fixed.size() + 1));
            switch (this.m_FillerType) {
                case MISSING_BOOLEAN: 
                case FILLER_BOOLEAN: {
                    fixed.add(name, DataType.BOOLEAN);
                    continue block8;
                }
                case MISSING_STRING: 
                case FILLER_STRING: {
                    fixed.add(name, DataType.STRING);
                    continue block8;
                }
                case MISSING_NUMERIC: 
                case FILLER_NUMERIC: {
                    fixed.add(name, DataType.NUMERIC);
                    continue block8;
                }
                case FIRST_VALUE: {
                    fixed.add(0, name, fixed.getTypes().get(0));
                    continue block8;
                }
                case LAST_VALUE: {
                    fixed.add(name, fixed.getTypes().get(fixed.size() - 1));
                    continue block8;
                }
            }
            throw new IllegalStateException("Unhandled filler type: " + (Object)((Object)this.m_FillerType));
        }
        return this.m_Converter.generateHeader(fixed);
    }

    protected Object doGenerateRow(List data) {
        ArrayList<Object> fixed = new ArrayList<Object>(data);
        while (fixed.size() > this.m_NumFeatures) {
            if (this.m_FillerType == FillerType.FIRST_VALUE) {
                fixed.remove(0);
                continue;
            }
            fixed.remove(fixed.size() - 1);
        }
        block9: while (fixed.size() < this.m_NumFeatures) {
            switch (this.m_FillerType) {
                case MISSING_BOOLEAN: 
                case MISSING_STRING: 
                case MISSING_NUMERIC: {
                    fixed.add(null);
                    continue block9;
                }
                case FILLER_BOOLEAN: {
                    fixed.add(this.m_FillerBoolean);
                    continue block9;
                }
                case FILLER_STRING: {
                    fixed.add(this.m_FillerString);
                    continue block9;
                }
                case FILLER_NUMERIC: {
                    fixed.add(this.m_FillerNumeric);
                    continue block9;
                }
                case FIRST_VALUE: {
                    fixed.add(0, fixed.get(0));
                    continue block9;
                }
                case LAST_VALUE: {
                    fixed.add(fixed.get(fixed.size() - 1));
                    continue block9;
                }
            }
            throw new IllegalStateException("Unhandled filler type: " + (Object)((Object)this.m_FillerType));
        }
        return this.m_Converter.generateRow(fixed);
    }

    public Object generateRow(List data) {
        if (this.m_Header == null) {
            throw new IllegalStateException("No header available! generatedHeader called?");
        }
        return this.doGenerateRow(data);
    }

    public static enum FillerType {
        MISSING_NUMERIC,
        MISSING_STRING,
        MISSING_BOOLEAN,
        FILLER_NUMERIC,
        FILLER_STRING,
        FILLER_BOOLEAN,
        FIRST_VALUE,
        LAST_VALUE;

    }
}

