/*
 * Decompiled with CFR 0.152.
 */
package adams.data.featureconverter;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.featureconverter.AbstractFeatureConverter;
import adams.data.featureconverter.HeaderDefinition;
import java.util.List;

public class Text
extends AbstractFeatureConverter<String, String> {
    private static final long serialVersionUID = 2245576408802564218L;
    protected String m_Separator;
    protected String m_MissingValue;

    @Override
    public String globalInfo() {
        return "Simple feature converter that generates a CSV-like textual output.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("separator", "separator", ",");
        this.m_OptionManager.add("missing-value", "missingValue", "");
    }

    public void setSeparator(String value) {
        this.m_Separator = value;
        this.reset();
    }

    public String getSeparator() {
        return this.m_Separator;
    }

    public String separatorTipText() {
        return "The separator to use between cells.";
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
        this.reset();
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The value to use for missing values.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "separator", this.m_Separator, "separator: ");
    }

    @Override
    public Class getDatasetFormat() {
        return String.class;
    }

    @Override
    public Class getRowFormat() {
        return String.class;
    }

    @Override
    protected String doGenerateHeader(HeaderDefinition header) {
        StringBuilder result = new StringBuilder();
        for (String name : header.getNames()) {
            if (result.length() > 0) {
                result.append(this.m_Separator);
            }
            result.append(Utils.doubleQuote(name));
        }
        return result.toString();
    }

    @Override
    protected String doGenerateRow(List data) {
        StringBuilder result = new StringBuilder();
        for (Object value : data) {
            if (result.length() > 0) {
                result.append(this.m_Separator);
            }
            if (value == null) {
                result.append(Utils.doubleQuote(this.m_MissingValue));
                continue;
            }
            result.append(Utils.doubleQuote(value.toString()));
        }
        return result.toString();
    }
}

