/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayHistogram;
import java.io.Serializable;
import java.util.List;

public abstract class AbstractHistogram<T extends DataContainer>
extends AbstractFilter<T> {
    private static final long serialVersionUID = 1836858988505886282L;
    protected ArrayHistogram m_Histogram;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("histogram", "histogram", this.getDefaultHistogram());
    }

    protected ArrayHistogram getDefaultHistogram() {
        return new ArrayHistogram();
    }

    public void setHistogram(ArrayHistogram value) {
        this.m_Histogram = value;
        this.reset();
    }

    public ArrayHistogram getHistogram() {
        return this.m_Histogram;
    }

    public String histogramTipText() {
        return "The array histogram setup to use for generating the histogram data.";
    }

    protected abstract double getY(DataPoint var1);

    protected abstract DataPoint newDataPoint(int var1, double var2);

    @Override
    protected T processData(T data) {
        int i;
        DataContainer result = data.getHeader();
        if (data.size() == 0) {
            return (T)result;
        }
        List points = data.toList();
        Serializable[] values = new Double[points.size()];
        for (i = 0; i < points.size(); ++i) {
            values[i] = Double.valueOf(this.getY((DataPoint)points.get(i)));
        }
        ArrayHistogram calc = (ArrayHistogram)this.m_Histogram.shallowCopy();
        calc.add(values);
        AbstractArrayStatistic.StatisticContainer cont = calc.calculate();
        double[] histo = new double[cont.getColumnCount()];
        for (i = 0; i < cont.getColumnCount(); ++i) {
            histo[i] = ((Number)cont.getCell(0, i)).doubleValue();
        }
        for (i = 0; i < histo.length; ++i) {
            DataPoint point = this.newDataPoint(i, histo[i]);
            result.add(point);
        }
        return (T)result;
    }
}

