/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import java.util.List;

public class DownSize<T extends DataContainer>
extends AbstractFilter<T> {
    private static final long serialVersionUID = -7633117391523711914L;
    protected int m_NumPoints;

    @Override
    public String globalInfo() {
        return "A filter that picks a specified number of evenly spaced data points from the data. Does not introduce extra data points if there are too few points.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-points", "numPoints", this.getDefaultNumPoints(), 1, null);
    }

    protected int getDefaultNumPoints() {
        return 100;
    }

    public void setNumPoints(int value) {
        this.m_NumPoints = value;
        this.reset();
    }

    public int getNumPoints() {
        return this.m_NumPoints;
    }

    public String numPointsTipText() {
        return "The number of points to pick from the input data.";
    }

    @Override
    protected T processData(T data) {
        if (data.size() <= this.m_NumPoints) {
            return (T)((DataContainer)data.getClone());
        }
        List points = data.toList();
        DataContainer result = data.getHeader();
        for (int i = 0; i < this.m_NumPoints; ++i) {
            int index = (int)Math.round((double)i * ((double)data.size() / (double)this.m_NumPoints));
            result.add((DataPoint)((DataPoint)points.get(index)).getClone());
        }
        return (T)result;
    }
}

