/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image;

import adams.data.image.BufferedImageHelper;
import java.io.Serializable;

public class IntArrayMatrixView
implements Serializable {
    private static final long serialVersionUID = -5901549787330341842L;
    protected int[] m_Data;
    protected int m_Width;
    protected int m_Height;

    public IntArrayMatrixView(int width, int height) {
        this(new int[width * height], width, height);
    }

    public IntArrayMatrixView(int[] data, int width, int height) {
        if (data.length != width * height) {
            throw new IllegalArgumentException("Length of array and width*height don't match: " + data.length + " != " + width * height);
        }
        this.m_Data = data;
        this.m_Width = width;
        this.m_Height = height;
    }

    public int[] getData() {
        return this.m_Data;
    }

    public int getWidth() {
        return this.m_Width;
    }

    public int getHeight() {
        return this.m_Height;
    }

    public int get(int x, int y) {
        return this.m_Data[this.m_Width * y + x];
    }

    public int[] getRGBA(int x, int y) {
        return BufferedImageHelper.split(this.get(x, y));
    }

    public void set(int x, int y, int value) {
        this.m_Data[this.m_Width * y + x] = value;
    }

    public void setRGBA(int x, int y, int[] rgba) {
        this.set(x, y, BufferedImageHelper.combine(rgba));
    }

    public String toString() {
        return "w=" + this.m_Width + ", h=" + this.m_Height;
    }
}

