/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.ClassLister;
import adams.core.io.FileFormatHandler;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.io.input.AbstractImageReader;

public abstract class AbstractImageWriter<T extends AbstractImageContainer>
extends AbstractOptionHandler
implements FileFormatHandler {
    private static final long serialVersionUID = -6170592942529644703L;

    @Override
    public abstract String getFormatDescription();

    @Override
    public abstract String[] getFormatExtensions();

    @Override
    public String getDefaultFormatExtension() {
        return this.getFormatExtensions()[0];
    }

    public abstract AbstractImageReader getCorrespondingReader();

    public boolean isAvailable() {
        return true;
    }

    protected void check(T cont) {
        if (cont == null) {
            throw new IllegalStateException("No image container provided!");
        }
    }

    protected abstract String doWrite(PlaceholderFile var1, T var2);

    public String write(PlaceholderFile file, T cont) {
        this.check(cont);
        return this.doWrite(file, cont);
    }

    public static String[] getWriters() {
        return ClassLister.getSingleton().getClassnames(AbstractImageWriter.class);
    }
}

