/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.data.io.output.AbstractReportWriter;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Report;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import java.util.Collections;
import java.util.List;

public abstract class AbstractSimpleCSVReportWriter<T extends Report>
extends AbstractReportWriter<T> {
    private static final long serialVersionUID = 1068874780353203514L;
    public static final String COL_FIELD = "Field";
    public static final String COL_TYPE = "Type";
    public static final String COL_VALUE = "Value";

    @Override
    public String globalInfo() {
        return "Writes reports in CSV file format.";
    }

    @Override
    public String getFormatDescription() {
        return "CSV file format";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{"csv"};
    }

    @Override
    protected boolean writeData(T data) {
        SpreadSheet sheet = new SpreadSheet();
        Row row = sheet.getHeaderRow();
        row.addCell(COL_FIELD).setContent(COL_FIELD);
        row.addCell(COL_TYPE).setContent(COL_TYPE);
        row.addCell(COL_VALUE).setContent(COL_VALUE);
        row = sheet.addRow("Parent ID");
        row.addCell(COL_FIELD).setContent("Parent ID");
        row.addCell(COL_TYPE).setContent(DataType.NUMERIC.toString());
        row.addCell(COL_VALUE).setContent("" + ((Report)data).getDatabaseID());
        List<AbstractField> fields = ((Report)data).getFields();
        Collections.sort(fields);
        for (int i = 0; i < fields.size(); ++i) {
            row = sheet.addRow(fields.get(i).toString());
            row.addCell(COL_FIELD).setContent(fields.get(i).toString());
            row.addCell(COL_TYPE).setContent(fields.get(i).getDataType().toString());
            row.addCell(COL_VALUE).setContent(((Report)data).getValue(fields.get(i)).toString());
        }
        boolean result = new CsvSpreadSheetWriter().write(sheet, this.m_Output.getAbsolutePath());
        if (!result) {
            this.getLogger().severe("Error writing report #" + ((Report)data).getDatabaseID() + " to " + this.m_Output);
        }
        return result;
    }
}

