/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.JAIImageReader;
import adams.data.io.output.AbstractImageWriter;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;

public class JAIImageWriter
extends AbstractImageWriter<BufferedImageContainer> {
    private static final long serialVersionUID = 6385191315392140321L;
    protected String[] m_FormatExtensions;

    @Override
    public String globalInfo() {
        return "Java Advanced Imaging (JAI) image writer for: " + Utils.flatten(this.getFormatExtensions(), ", ");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FormatExtensions = ImageIO.getWriterFileSuffixes();
    }

    @Override
    public String getFormatDescription() {
        return "JAI";
    }

    @Override
    public String[] getFormatExtensions() {
        return this.m_FormatExtensions;
    }

    @Override
    public AbstractImageReader getCorrespondingReader() {
        return new JAIImageReader();
    }

    public ImageWriter getWriter() {
        return BufferedImageHelper.getWriterForExtension(this.getDefaultFormatExtension());
    }

    @Override
    protected String doWrite(PlaceholderFile file, BufferedImageContainer cont) {
        return BufferedImageHelper.write((BufferedImage)cont.getImage(), file);
    }
}

