/*
 * Decompiled with CFR 0.152.
 */
package adams.data.report;

import adams.core.base.BaseRegExp;
import adams.data.container.DataContainer;
import adams.data.report.AbstractField;
import adams.data.report.AbstractReportFilter;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;

public class RemoveByName
extends AbstractReportFilter {
    private static final long serialVersionUID = 1215043320920480970L;
    protected BaseRegExp m_RegExp;
    protected boolean m_InvertMatching;

    @Override
    public String globalInfo() {
        return "Removes all fields from the report which names match the specified regular expression. Matching can be inverted as well.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reg-exp", "regExp", new BaseRegExp(".*"));
        this.m_OptionManager.add("invert-matching", "invertMatching", false);
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression that the field names must match to get removed (or being kept, if matching is inverted).";
    }

    public void setInvertMatching(boolean value) {
        this.m_InvertMatching = value;
        this.reset();
    }

    public boolean getInvertMatching() {
        return this.m_InvertMatching;
    }

    public String invertMatchingTipText() {
        return "If enabled the fields that don't match are retained rather than deleted.";
    }

    protected DataContainer processData(DataContainer data) {
        if (!(data instanceof MutableReportHandler)) {
            return data;
        }
        Object oldReport = ((MutableReportHandler)((Object)data)).getReport();
        Report newReport = Report.newInstance(oldReport);
        for (AbstractField field : ((Report)oldReport).getFields()) {
            if (this.m_InvertMatching) {
                if (!this.m_RegExp.isMatch(field.getName())) continue;
                newReport.addField(field);
                newReport.setValue(field, ((Report)oldReport).getValue(field));
                continue;
            }
            if (this.m_RegExp.isMatch(field.getName())) continue;
            newReport.addField(field);
            newReport.setValue(field, ((Report)oldReport).getValue(field));
        }
        ((MutableReportHandler)((Object)data)).setReport(newReport);
        return data;
    }
}

