/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.data.statistics.AbstractArrayDistance;

public class ArrayMinkowskiDistance
extends AbstractArrayDistance {
    private static final long serialVersionUID = 6119558442855668422L;
    protected double m_Exponent;

    @Override
    protected String getDistanceName() {
        return "Minkowski";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("exponent", "exponent", 2.0);
    }

    public void setExponent(double value) {
        this.m_Exponent = value;
        this.reset();
    }

    public double getExponent() {
        return this.m_Exponent;
    }

    public String exponentTipText() {
        return "The exponent 'p' to use for 'sum(|x-y|^p)^(1/p)'.";
    }

    @Override
    protected String createCellHeader() {
        return super.createCellHeader() + " (p=" + this.m_Exponent + ")";
    }

    @Override
    protected double calcDistance(double[] first, double[] second) {
        double result = 0.0;
        for (int i = 0; i < first.length; ++i) {
            result += Math.pow(Math.abs(first[i] - second[i]), this.m_Exponent);
        }
        result = Math.pow(result, 1.0 / this.m_Exponent);
        return result;
    }
}

