/*
 * Decompiled with CFR 0.152.
 */
package adams.env;

import adams.core.Properties;
import adams.core.StaticClassLister;
import adams.core.logging.LoggingObject;
import adams.core.management.OS;
import adams.core.option.OptionUtils;
import adams.env.AbstractPropertiesDefinition;
import adams.env.Database;
import adams.env.Environment;
import adams.env.Setup;
import adams.gui.application.AbstractApplicationFrame;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public abstract class AbstractEnvironment
extends LoggingObject
implements Serializable {
    private static final long serialVersionUID = -2199293612498875147L;
    public static final String FILENAME = "PropertiesDefinitions.props";
    public static final String KEY_DEFINITIONS = "Definitions";
    protected static Class m_EnvironmentClass;
    protected static AbstractEnvironment m_Environment;
    protected static Database m_Database;
    protected static File m_HomeDirectory;
    protected Hashtable<String, List<Setup>> m_Properties;
    protected Hashtable<String, AbstractPropertiesDefinition> m_Definitions;
    protected AbstractApplicationFrame m_ApplicationFrame;

    protected AbstractEnvironment() {
        this.initialize();
        this.finishInit();
        this.setUp();
    }

    protected void initialize() {
        m_Database = new Database();
    }

    protected void finishInit() {
        File file = m_HomeDirectory == null ? new File(this.getDefaultHome()) : m_HomeDirectory.getAbsoluteFile();
        if (!file.exists()) {
            if (!file.mkdir()) {
                m_HomeDirectory = new File(System.getProperty("user.dir"));
                System.err.println(this.getClass().getName() + ": Failed to create project home directory '" + this.getDefaultHome() + "'");
            } else {
                m_HomeDirectory = file;
            }
        } else {
            m_HomeDirectory = file;
        }
        if (!m_HomeDirectory.getAbsolutePath().equals(this.getDefaultHome())) {
            System.err.println(this.getClass().getName() + ": Using home directory '" + m_HomeDirectory + "'");
        }
    }

    protected abstract List<String> getPropertiesDefinitions();

    protected void setUp() {
        String[] definitions;
        this.m_Properties = new Hashtable();
        this.m_Definitions = new Hashtable();
        for (String name : definitions = StaticClassLister.getSingleton().getClasses(this.getPropertiesDefinitions(), KEY_DEFINITIONS)) {
            try {
                AbstractPropertiesDefinition definition = (AbstractPropertiesDefinition)Class.forName(name).newInstance();
                definition.update(this);
                this.m_Definitions.put(definition.getKey(), definition);
            }
            catch (Exception e) {
                System.err.println("Failed to process definition '" + name + "':");
                e.printStackTrace();
            }
        }
    }

    public abstract String getProject();

    public static void setHome(String value) {
        m_HomeDirectory = value == null || value.length() == 0 ? null : new File(value);
    }

    public String getDefaultHome(String project) {
        if (OS.isWindows()) {
            return System.getProperty("user.home") + "/_" + project;
        }
        return System.getProperty("user.home") + "/." + project;
    }

    public String getDefaultHome() {
        return this.getDefaultHome(this.getProject());
    }

    public String getHome() {
        if (m_HomeDirectory == null) {
            return this.getDefaultHome();
        }
        return m_HomeDirectory.getAbsolutePath();
    }

    public Database getDatabase() {
        return m_Database;
    }

    protected Hashtable<String, List<Setup>> getProperties() {
        return this.m_Properties;
    }

    public List<String> getDirectories(String propsfile, String home) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(propsfile.replaceAll("\\/[^/]*$", ""));
        if (home != null) {
            result.add(home);
        }
        result.add(System.getProperty("user.dir"));
        return result;
    }

    public List<String> getDirectories(String propsfile) {
        return this.getDirectories(propsfile, this.getHome());
    }

    public void add(String key, String propsfile, String[] overrides) {
        this.add(key, propsfile, this.getDirectories(propsfile), overrides);
    }

    public void add(String key, String propsfile, String home, String[] overrides) {
        this.add(key, propsfile, this.getDirectories(propsfile, home), overrides);
    }

    public void add(String key, String propsfile, List<String> dirs, String[] overrides) {
        Setup setup = new Setup(propsfile, dirs, overrides);
        if (!this.m_Properties.containsKey(key)) {
            this.m_Properties.put(key, new ArrayList());
        }
        if (!this.m_Properties.get(key).contains(setup)) {
            this.m_Properties.get(key).add(setup);
        }
    }

    public void replace(String key, String propsfile) {
        this.replace(key, propsfile, this.getDirectories(propsfile));
    }

    public void replace(String key, String propsfile, String home) {
        this.replace(key, propsfile, this.getDirectories(propsfile, home));
    }

    public void replace(String key, String propsfile, List<String> dirs) {
        this.m_Properties.put(key, new ArrayList());
        this.m_Properties.get(key).add(new Setup(propsfile, dirs));
    }

    public Iterator<String> keys() {
        return this.m_Properties.keySet().iterator();
    }

    public String getKey(String propsfile) {
        String result = null;
        Enumeration<String> keys = this.m_Properties.keys();
        block0: while (keys.hasMoreElements() && result == null) {
            String key = keys.nextElement();
            for (Setup setup : this.m_Properties.get(key)) {
                if (!setup.getPropertiesFile().equals(propsfile)) continue;
                result = key;
                continue block0;
            }
        }
        return result;
    }

    public synchronized Properties read(String key) {
        Properties result = new Properties();
        if (this.m_Properties.containsKey(key)) {
            Setup setup;
            int i;
            List<Setup> files = this.m_Properties.get(key);
            if (this.isLoggingEnabled()) {
                this.getLogger().log(Level.INFO, "key=" + key + ", files=" + files);
            }
            ArrayList<Properties> props = new ArrayList<Properties>();
            for (i = 0; i < files.size(); ++i) {
                setup = files.get(i);
                try {
                    Properties other = Properties.read(setup.getFilename(), setup.getDirectories());
                    props.add(other);
                    continue;
                }
                catch (Exception e) {
                    props.add(new Properties());
                }
            }
            for (i = 1; i < files.size(); ++i) {
                setup = files.get(i);
                if (!setup.hasOverrides()) continue;
                List<String> overrides = setup.getOverrides();
                for (int n = 0; n < overrides.size(); ++n) {
                    ((Properties)props.get(i - 1)).removeKeysRecursive(overrides.get(n));
                }
            }
            for (i = 0; i < files.size(); ++i) {
                setup = files.get(i);
                result.mergeWith((Properties)props.get(i));
            }
        }
        return result;
    }

    public boolean write(String key, Properties props) {
        boolean result = false;
        String filename = this.getCustomPropertiesFilename(key);
        if (filename == null) {
            System.err.println("Properties definition '" + key + "' not found, properties not saved!");
            return result;
        }
        result = props.save(filename);
        return result;
    }

    public String getCustomPropertiesFilename(String key) {
        AbstractPropertiesDefinition definition = this.m_Definitions.get(key);
        if (definition == null) {
            System.err.println("Properties definition '" + key + "' not found!");
            return null;
        }
        return this.createPropertiesFilename(definition.getFile());
    }

    public String createPropertiesFilename(String file) {
        return AbstractEnvironment.getInstance().getDefaultHome() + File.separator + file;
    }

    public void setApplicationFrame(AbstractApplicationFrame value) {
        this.m_ApplicationFrame = value;
    }

    public AbstractApplicationFrame getApplicationFrame() {
        return this.m_ApplicationFrame;
    }

    public static synchronized AbstractEnvironment getInstance() {
        if (m_Environment == null) {
            try {
                m_Environment = (AbstractEnvironment)m_EnvironmentClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                m_Environment = new Environment();
            }
        }
        return m_Environment;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(this.m_Properties.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            result.append("\n--> " + key + "\n");
            List<Setup> setups = this.m_Properties.get(key);
            for (Setup setup : setups) {
                result.append(setup.toString() + "\n");
            }
        }
        return result.toString();
    }

    public static void setEnvironmentClass(Class cls) {
        m_EnvironmentClass = cls;
        m_Environment = null;
    }

    public static Class getEnvironmentClass() {
        return m_EnvironmentClass;
    }

    public static void runEnvironment(Class env, String[] args) throws Exception {
        String res;
        if (OptionUtils.helpRequested(args)) {
            System.out.println();
            System.out.println("Usage: " + env.getName() + " [-project] [-home] [-definitions] [-properties] [-resource path]");
            System.out.println();
            return;
        }
        AbstractEnvironment.setEnvironmentClass(env);
        if (OptionUtils.hasFlag(args, "-project")) {
            System.out.println(AbstractEnvironment.getInstance().getProject());
        }
        if (OptionUtils.hasFlag(args, "-home")) {
            System.out.println(AbstractEnvironment.getInstance().getHome());
        }
        if (OptionUtils.hasFlag(args, "-definitions")) {
            System.out.println(AbstractEnvironment.getInstance().m_Definitions);
        }
        if (OptionUtils.hasFlag(args, "-properties")) {
            System.out.println(AbstractEnvironment.getInstance().getProperties());
        }
        if ((res = OptionUtils.getOption(args, "-resource")) != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream(res)));
            String line = null;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            reader.close();
        }
    }
}

