/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.Variables;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Unknown;
import adams.parser.BooleanExpression;
import adams.parser.BooleanExpressionText;
import adams.parser.GrammarSupplier;
import java.util.HashMap;
import java.util.logging.Level;

public abstract class AbstractExpression
extends AbstractBooleanCondition
implements GrammarSupplier {
    private static final long serialVersionUID = 4442436759501167843L;
    protected BooleanExpressionText m_Expression;

    @Override
    public String getGrammar() {
        return new BooleanExpression().getGrammar();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expression", "expression", this.getDefaultExpression());
    }

    protected abstract BooleanExpressionText getDefaultExpression();

    public void setExpression(BooleanExpressionText value) {
        if (Variables.isPlaceholder(value.getValue())) {
            value = new BooleanExpressionText("(" + value.getValue() + ")");
        }
        this.m_Expression = value;
        this.reset();
    }

    public BooleanExpressionText getExpression() {
        return this.m_Expression;
    }

    public abstract String expressionTipText();

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "expression", this.m_Expression);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp(Actor owner) {
        String result = super.setUp(owner);
        if (result == null && (this.m_Expression == null || this.m_Expression.getValue().length() == 0)) {
            result = "No expression provided!";
        }
        return result;
    }

    protected boolean doEvaluate(String exp, HashMap symbols) {
        boolean result;
        try {
            result = BooleanExpression.evaluate(exp, symbols);
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("exp: " + this.getExpression() + "\n" + "  --> " + exp + "\n" + "  = " + result);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error evaluating boolean expression: " + exp, e);
            result = false;
        }
        return result;
    }
}

