/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.core.Token;

public class HasStorageValue
extends AbstractBooleanCondition {
    private static final long serialVersionUID = -1349114354556041598L;
    protected StorageName m_StorageName;

    @Override
    public String globalInfo() {
        return "Evaluates to true if the specified storage value is present.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", new StorageName("storage"));
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "storageName", this.m_StorageName, "storage: ");
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the storage value to check.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Object.class};
    }

    @Override
    protected boolean doEvaluate(Actor owner, Token token) {
        return owner.getStorageHandler().getStorage().has(this.m_StorageName);
    }
}

