/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.ClassLocator;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;

public class IsSubClass
extends AbstractBooleanCondition {
    private static final long serialVersionUID = 912094591109587908L;
    protected String m_SuperClass;
    protected Class m_Class;

    @Override
    public String globalInfo() {
        return "Evaluates to 'true' if the objects are derived from the specified superclass.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("super-class", "superClass", Object.class.getName());
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Class = null;
    }

    public void setSuperClass(String value) {
        this.m_SuperClass = value;
        this.reset();
    }

    public String getSuperClass() {
        return this.m_SuperClass;
    }

    public String superClassTipText() {
        return "The super class that the objects must be derived from.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "superClass", this.m_SuperClass, "super: ");
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp(Actor owner) {
        String result = super.setUp(owner);
        if (result == null) {
            if (this.m_SuperClass == null || this.m_SuperClass.trim().length() == 0) {
                result = "No super class provided!";
            } else {
                try {
                    this.m_Class = Class.forName(this.m_SuperClass);
                }
                catch (Exception e) {
                    result = "Failed to load super class: " + e;
                }
            }
        }
        return result;
    }

    @Override
    protected boolean doEvaluate(Actor owner, Token token) {
        if (token != null && token.getPayload() != null) {
            return ClassLocator.isSubclass(this.m_Class, token.getPayload().getClass());
        }
        return false;
    }
}

