/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.DateUtils;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.Variables;
import adams.core.VariablesHandler;
import adams.core.io.FlowFile;
import adams.core.option.OptionHandler;
import adams.db.LogEntry;
import adams.db.MutableLogEntryHandler;
import adams.flow.control.MutableConnectedControlActor;
import adams.flow.control.ScopeHandler;
import adams.flow.control.Storage;
import adams.flow.control.StorageHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.FlowVariables;
import adams.flow.core.PauseStateHandler;
import adams.flow.core.PauseStateManager;
import adams.flow.core.TriggerableEvent;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.FlowExecutionListeningSupporter;
import adams.flow.execution.ListenerUtils;
import adams.flow.execution.MultiListener;
import adams.flow.execution.NullListener;
import adams.gui.core.BaseFrame;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class Flow
extends MutableConnectedControlActor
implements MutableLogEntryHandler,
StorageHandler,
VariablesHandler,
TriggerableEvent,
PauseStateHandler,
FlowExecutionListeningSupporter,
ScopeHandler {
    private static final long serialVersionUID = 723059748204261319L;
    protected ErrorHandling m_ErrorHandling;
    protected boolean m_LogErrors;
    protected ArrayList<LogEntry> m_LogEntries;
    protected transient Storage m_Storage;
    protected FlowVariables m_Variables;
    protected FlowFile m_ExecuteOnError;
    protected AbstractActor m_ExecuteOnErrorActor;
    protected FlowFile m_ExecuteOnFinish;
    protected AbstractActor m_ExecuteOnFinishActor;
    protected AbstractActor m_AfterExecuteActor;
    protected PauseStateManager m_PauseStateManager;
    protected boolean m_FlowExecutionListeningEnabled;
    protected FlowExecutionListener m_FlowExecutionListener;
    protected transient BaseFrame m_FlowExecutionListenerFrame;
    protected HashSet<String> m_CallableNames;
    protected boolean m_EnforceCallableNameCheck;
    protected transient Component m_ParentComponent;

    @Override
    public String globalInfo() {
        return "Container object for actors, used for executing a flow.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("error-handling", "errorHandling", (Object)ErrorHandling.ACTORS_ALWAYS_STOP_ON_ERROR);
        this.m_OptionManager.add("log-errors", "logErrors", false);
        this.m_OptionManager.add("execute-on-error", "executeOnError", new FlowFile("."));
        this.m_OptionManager.add("execute-on-finish", "executeOnFinish", new FlowFile("."));
        this.m_OptionManager.add("flow-execution-listening-enabled", "flowExecutionListeningEnabled", false);
        this.m_OptionManager.add("flow-execution-listener", "flowExecutionListener", new NullListener());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_LogEntries = new ArrayList();
        this.m_Variables = new FlowVariables();
        this.m_ExecuteOnErrorActor = null;
        this.m_ExecuteOnFinishActor = null;
        this.m_PauseStateManager = new PauseStateManager();
        this.m_CallableNames = new HashSet();
        this.m_EnforceCallableNameCheck = true;
        this.m_ParentComponent = null;
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_AfterExecuteActor = null;
        this.m_CallableNames.clear();
    }

    @Override
    public String getQuickInfo() {
        String result = "";
        String value = QuickInfoHelper.toString((OptionHandler)this, "executeOnError", this.m_ExecuteOnError.isDirectory() ? null : this.m_ExecuteOnError);
        if (value != null) {
            result = result + "on error: " + value;
        }
        if ((value = QuickInfoHelper.toString((OptionHandler)this, "executeOnFinish", this.m_ExecuteOnFinish.isDirectory() ? null : this.m_ExecuteOnFinish)) != null) {
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + "on finish: " + value;
        }
        if (this.m_FlowExecutionListeningEnabled || QuickInfoHelper.hasVariable(this, "executionListener")) {
            value = QuickInfoHelper.toString((OptionHandler)this, "executionListener", this.m_FlowExecutionListener, "listener: ");
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + value;
        }
        if (super.getQuickInfo() != null) {
            result = result + ", " + super.getQuickInfo();
        }
        return result;
    }

    @Override
    public String actorsTipText() {
        return "All the actors that define this flow.";
    }

    public void setErrorHandling(ErrorHandling value) {
        this.m_ErrorHandling = value;
        this.reset();
    }

    public ErrorHandling getErrorHandling() {
        return this.m_ErrorHandling;
    }

    public String errorHandlingTipText() {
        return "Defines how errors are handled that occur during execution of the flow; " + (Object)((Object)ErrorHandling.ACTORS_DECIDE_TO_STOP_ON_ERROR) + " stops the " + "flow only if the actor has the 'stopFlowOnError' flag set.";
    }

    public void setLogErrors(boolean value) {
        this.m_LogErrors = value;
        this.reset();
    }

    public boolean getLogErrors() {
        return this.m_LogErrors;
    }

    public String logErrorsTipText() {
        return "If set to true, errors are logged and can be retrieved after execution.";
    }

    public void setExecuteOnError(FlowFile value) {
        this.m_ExecuteOnError = value;
        this.reset();
    }

    public FlowFile getExecuteOnError() {
        return this.m_ExecuteOnError;
    }

    public String executeOnErrorTipText() {
        return "The external flow to execute in case the flow finishes with an error; allows the user to call a clean-up flow.";
    }

    public void setExecuteOnFinish(FlowFile value) {
        this.m_ExecuteOnFinish = value;
        this.reset();
    }

    public FlowFile getExecuteOnFinish() {
        return this.m_ExecuteOnFinish;
    }

    public String executeOnFinishTipText() {
        return "The external flow to execute in case the flow finishes normal, without any errors.";
    }

    @Override
    public void setFlowExecutionListeningEnabled(boolean value) {
        this.m_FlowExecutionListeningEnabled = value;
        this.reset();
    }

    @Override
    public boolean isFlowExecutionListeningEnabled() {
        return this.m_FlowExecutionListeningEnabled;
    }

    public String flowExecutionListeningEnabledTipText() {
        return "Enables/disables the flow execution listener.";
    }

    @Override
    public void setFlowExecutionListener(FlowExecutionListener l) {
        this.m_FlowExecutionListener = l;
        this.reset();
    }

    @Override
    public FlowExecutionListener getFlowExecutionListener() {
        return this.m_FlowExecutionListener;
    }

    public String flowExecutionListenerTipText() {
        return "The listener for the flow execution; must be enabled explicitly.";
    }

    @Override
    public boolean canStartListeningAtRuntime() {
        return true;
    }

    @Override
    public boolean startListeningAtRuntime(FlowExecutionListener l) {
        boolean result = true;
        if (l instanceof NullListener) {
            if (this.m_FlowExecutionListeningEnabled) {
                this.m_FlowExecutionListener.finishListening();
                this.m_FlowExecutionListeningEnabled = false;
                if (this.m_FlowExecutionListenerFrame != null) {
                    this.m_FlowExecutionListenerFrame.dispose();
                }
            }
            this.m_FlowExecutionListener = l;
            return result;
        }
        if (!this.m_FlowExecutionListeningEnabled) {
            this.m_FlowExecutionListeningEnabled = true;
        }
        if (this.m_FlowExecutionListener instanceof NullListener) {
            this.m_FlowExecutionListener.finishListening();
            this.m_FlowExecutionListener = l;
            this.m_FlowExecutionListener.startListening();
        } else {
            ArrayList<Object> listeners;
            MultiListener multi;
            if (this.m_FlowExecutionListener instanceof MultiListener) {
                multi = (MultiListener)this.m_FlowExecutionListener;
                listeners = new ArrayList<FlowExecutionListener>(Arrays.asList(multi.getSubListeners()));
            } else {
                multi = new MultiListener();
                listeners = new ArrayList();
                multi.startListening();
            }
            listeners.add(l);
            multi.setSubListeners(listeners.toArray(new FlowExecutionListener[listeners.size()]));
            this.m_FlowExecutionListener = multi;
            l.startListening();
        }
        if (this.m_FlowExecutionListenerFrame != null) {
            this.m_FlowExecutionListenerFrame.dispose();
        }
        this.m_FlowExecutionListenerFrame = ListenerUtils.createFrame(this);
        return result;
    }

    public void setParentComponent(Component value) {
        this.m_ParentComponent = value;
    }

    @Override
    public Component getParentComponent() {
        return this.m_ParentComponent;
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(true, ActorExecution.SEQUENTIAL, false);
    }

    @Override
    public synchronized Variables getVariables() {
        return this.getLocalVariables();
    }

    @Override
    public synchronized void setVariables(Variables value) {
    }

    @Override
    public synchronized Variables getLocalVariables() {
        this.getOptionManager().setVariables(this.m_Variables);
        return this.m_Variables;
    }

    @Override
    public PauseStateManager getPauseStateManager() {
        return this.m_PauseStateManager;
    }

    @Override
    public AbstractActor getRoot() {
        return this;
    }

    @Override
    public String getFullName() {
        this.m_FullName = null;
        return super.getFullName();
    }

    @Override
    protected String setUpSubActors() {
        String result = super.setUpSubActors();
        if (result == null) {
            result = ActorUtils.checkForSource(this.getActors());
        }
        return result;
    }

    @Override
    protected void forceVariables(Variables value) {
        if (value instanceof FlowVariables) {
            ((FlowVariables)value).setFlow(this);
        }
        super.forceVariables(value);
    }

    @Override
    public String setUp() {
        ArrayList<String> errors;
        this.forceVariables(this.getVariables());
        String result = super.setUp();
        this.m_LogEntries.clear();
        if (result == null && !this.m_ExecuteOnError.isDirectory() && this.m_ExecuteOnError.exists()) {
            errors = new ArrayList<String>();
            this.m_ExecuteOnErrorActor = ActorUtils.read(this.m_ExecuteOnError.getAbsolutePath(), errors);
            result = !errors.isEmpty() ? "Error loading execute-on-error actor '" + this.m_ExecuteOnError.getAbsolutePath() + "':\n" + Utils.flatten(errors, "\n") : (this.m_ExecuteOnErrorActor == null ? "Error loading execute-on-error actor '" + this.m_ExecuteOnError.getAbsolutePath() + "'!" : this.m_ExecuteOnErrorActor.setUp());
        }
        if (result == null && !this.m_ExecuteOnFinish.isDirectory() && this.m_ExecuteOnFinish.exists()) {
            errors = new ArrayList();
            this.m_ExecuteOnFinishActor = ActorUtils.read(this.m_ExecuteOnFinish.getAbsolutePath(), errors);
            result = !errors.isEmpty() ? "Finish loading execute-on-finish actor '" + this.m_ExecuteOnFinish.getAbsolutePath() + "':\n" + Utils.flatten(errors, "\n") : (this.m_ExecuteOnFinishActor == null ? "Finish loading execute-on-finish actor '" + this.m_ExecuteOnFinish.getAbsolutePath() + "'!" : this.m_ExecuteOnFinishActor.setUp());
        }
        if (result != null) {
            this.getLogger().severe(result);
        }
        return result;
    }

    @Override
    public void clearLogEntries() {
        this.m_LogEntries.clear();
    }

    @Override
    public List<LogEntry> getLogEntries() {
        return this.m_LogEntries;
    }

    @Override
    public void addLogEntry(LogEntry entry) {
        if (this.m_LogErrors) {
            this.m_LogEntries.add(entry);
        }
    }

    @Override
    public LogEntry getLogEntry(int index) {
        return this.m_LogEntries.get(index);
    }

    @Override
    public LogEntry removeLogEntry(int index) {
        return this.m_LogEntries.remove(index);
    }

    @Override
    public int countLogEntries() {
        return this.m_LogEntries.size();
    }

    @Override
    public synchronized Storage getStorage() {
        if (this.m_Storage == null) {
            this.m_Storage = new Storage();
        }
        return this.m_Storage;
    }

    @Override
    public void setEnforceCallableNameCheck(boolean value) {
        this.m_EnforceCallableNameCheck = value;
    }

    @Override
    public boolean getEnforceCallableNameCheck() {
        return this.m_EnforceCallableNameCheck;
    }

    @Override
    public boolean isCallableNameUsed(String name) {
        if (!this.getEnforceCallableNameCheck()) {
            return false;
        }
        return this.m_CallableNames.contains(name);
    }

    @Override
    public String addCallableName(String name) {
        if (!this.getEnforceCallableNameCheck()) {
            return null;
        }
        if (this.isCallableNameUsed(name)) {
            return "Callable name '" + name + "' is already used in this scope ('" + this.getFullName() + "')!";
        }
        this.m_CallableNames.add(name);
        return null;
    }

    @Override
    protected String doExecute() {
        Date start = null;
        Date finish = null;
        this.m_FlowExecutionListenerFrame = null;
        if (this.m_FlowExecutionListeningEnabled) {
            this.m_FlowExecutionListener.startListening();
            this.m_FlowExecutionListenerFrame = ListenerUtils.createFrame(this);
        }
        if (this.m_Headless) {
            start = new Date();
            System.out.println();
            System.out.println("--> Start: " + DateUtils.getTimestampFormatterMsecs().format(start));
            System.out.println();
        }
        String result = super.doExecute();
        if (this.m_Headless) {
            finish = new Date();
            System.out.println();
            System.out.println("--> Finish: " + DateUtils.getTimestampFormatterMsecs().format(finish));
            System.out.println("--> Duration: " + DateUtils.msecToString(DateUtils.difference(start, finish)) + "\n");
            System.out.println();
        }
        this.m_AfterExecuteActor = null;
        if (this.m_Stopped) {
            if (this.m_ExecuteOnErrorActor != null) {
                this.m_AfterExecuteActor = this.m_ExecuteOnErrorActor;
            }
        } else if (result == null && this.m_ExecuteOnFinishActor != null) {
            this.m_AfterExecuteActor = this.m_ExecuteOnFinishActor;
        }
        if (this.m_AfterExecuteActor != null) {
            this.m_AfterExecuteActor.execute();
            this.m_AfterExecuteActor.wrapUp();
        }
        if (this.m_FlowExecutionListeningEnabled) {
            this.m_FlowExecutionListener.finishListening();
        }
        return result;
    }

    @Override
    public String execute() {
        String result = super.execute();
        if (result != null) {
            this.getLogger().severe(result);
        }
        return result;
    }

    @Override
    public void cleanUp() {
        this.m_LogEntries.clear();
        this.m_CallableNames.clear();
        if (this.m_Storage != null) {
            this.m_Storage.clear();
            this.m_Storage = null;
        }
        if (this.m_AfterExecuteActor != null) {
            this.m_AfterExecuteActor.destroy();
            this.m_AfterExecuteActor = null;
        }
        if (this.m_FlowExecutionListenerFrame != null) {
            this.m_FlowExecutionListenerFrame.dispose();
            this.m_FlowExecutionListenerFrame = null;
        }
        this.m_Variables.cleanUp();
        super.cleanUp();
    }

    @Override
    public void destroy() {
        this.m_Variables.cleanUp();
        super.destroy();
    }

    public static enum ErrorHandling {
        ACTORS_ALWAYS_STOP_ON_ERROR,
        ACTORS_DECIDE_TO_STOP_ON_ERROR;

    }
}

