/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.logging.LoggingObject;
import adams.flow.control.AbstractDirectedControlActor;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractCallableActor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHandler;
import adams.flow.core.CallableActorReference;
import adams.flow.core.ExternalActorHandler;
import adams.flow.core.MutableActorHandler;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.sink.CallableSink;
import adams.flow.source.CallableSource;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.CallableTransformer;
import java.util.List;

public class CallableActorHelper
extends LoggingObject {
    private static final long serialVersionUID = -763479272812116920L;

    public AbstractActor findCallableActor(ActorHandler group, CallableActorReference name) {
        AbstractActor result = null;
        for (int i = 0; i < group.size(); ++i) {
            ExternalActorHandler external;
            if (group.get(i) instanceof CallableActorHandler) {
                CallableActorHandler callable = (CallableActorHandler)((Object)group.get(i));
                int index = callable.indexOf(name.toString());
                if (index <= -1) continue;
                result = callable.get(index);
                break;
            }
            if (group.get(i) instanceof ExternalActorHandler && (external = (ExternalActorHandler)((Object)group.get(i))).getExternalActor() instanceof ActorHandler && (result = this.findCallableActor((ActorHandler)((Object)external.getExternalActor()), name)) != null) break;
        }
        return result;
    }

    public AbstractActor findCallableActor(AbstractActor root, CallableActorReference name) {
        AbstractActor result = null;
        if (root == null) {
            this.getLogger().severe("No root container found!");
        } else if (!(root instanceof AbstractDirectedControlActor)) {
            this.getLogger().severe("Root is not a container ('" + root.getFullName() + "'/" + root.getClass().getName() + ")!");
            root = null;
        }
        if (root != null) {
            result = this.findCallableActor((ActorHandler)((Object)root), name);
        }
        return result;
    }

    public AbstractActor findCallableActorRecursive(AbstractActor actor, CallableActorReference name) {
        AbstractActor result = null;
        List<ActorHandler> handlers = ActorUtils.findActorHandlers(actor, true);
        for (int i = 0; i < handlers.size() && (result = this.findCallableActor(handlers.get(i), name)) == null; ++i) {
        }
        return result;
    }

    protected static Object getSetup(Class cls, CallableActorReference callableName, AbstractActor start, AbstractCallableActor callable) {
        Object result = null;
        callable.setCallableName(callableName);
        callable.setParent(start.getParent());
        if (callable.setUp() == null) {
            callable.execute();
            Token token = ((OutputProducer)((Object)callable)).output();
            if (token != null) {
                result = token.getPayload();
                if (cls != null && !cls.isInstance(result)) {
                    result = null;
                }
                AbstractActor actor = callable.getCallableActor();
                callable.wrapUp();
                callable.cleanUp();
                if (actor != null) {
                    actor.setUp();
                }
            }
        }
        return result;
    }

    public static Object getSetup(Class cls, CallableActorReference callableName, AbstractActor start) {
        Object result = CallableActorHelper.getSetupFromSource(cls, callableName, start);
        if (result == null) {
            result = CallableActorHelper.getSetupFromTransformer(cls, callableName, start);
        }
        return result;
    }

    public static Object getSetupFromSource(Class cls, CallableActorReference callableName, AbstractActor start) {
        return CallableActorHelper.getSetup(cls, callableName, start, new CallableSource());
    }

    public static Object getSetupFromTransformer(Class cls, CallableActorReference callableName, AbstractActor start) {
        return CallableActorHelper.getSetup(cls, callableName, start, new CallableTransformer());
    }

    public static List<AbstractActor> findAllCallableActors(AbstractActor flow) {
        return ActorUtils.enumerate(flow.getRoot(), new Class[]{CallableActors.class});
    }

    public static CallableActors createCallableActors(AbstractActor actor, boolean insert) {
        CallableActors result = null;
        List<ActorHandler> callable = ActorUtils.findActorHandlers(actor, true, true);
        int i = 0;
        while (i < callable.size()) {
            if (callable.get(i) instanceof CallableActors) {
                ++i;
                continue;
            }
            callable.remove(i);
        }
        if (callable.size() == 0 && insert) {
            AbstractActor root = actor.getRoot();
            if (!((ActorHandler)((Object)root)).getActorHandlerInfo().canContainStandalones()) {
                System.err.println("Root actor '" + root.getName() + "' cannot contain standalones!");
                return null;
            }
            result = new CallableActors();
            if (root instanceof MutableActorHandler) {
                ((MutableActorHandler)((Object)root)).add(0, result);
            } else {
                System.err.println("Cannot add " + CallableActors.class.getSimpleName() + " container to root actor!");
            }
        } else {
            result = (CallableActors)callable.get(callable.size() - 1);
        }
        return result;
    }

    public static AbstractActor createCallableActor(AbstractActor actor) {
        CallableActors callableActors = CallableActorHelper.createCallableActors(actor, true);
        if (callableActors == null) {
            return null;
        }
        int index = actor.index();
        ActorHandler parent = (ActorHandler)((Object)actor.getParent());
        callableActors.add(actor);
        AbstractCallableActor replacement = null;
        if (ActorUtils.isSource(actor)) {
            replacement = new CallableSource();
        } else if (ActorUtils.isTransformer(actor)) {
            replacement = new CallableTransformer();
        } else if (ActorUtils.isSink(actor)) {
            replacement = new CallableSink();
        }
        replacement.setCallableName(new CallableActorReference(actor.getName()));
        parent.set(index, replacement);
        return replacement;
    }
}

