/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.ClassLocator;
import adams.core.base.BaseObject;
import adams.core.io.PlaceholderFile;
import adams.flow.core.AbstractPropertyValueConverter;
import java.io.File;

public class DefaultPropertyValueConverter
extends AbstractPropertyValueConverter {
    private static final long serialVersionUID = 5709690907332699331L;

    @Override
    public boolean handles(Class cls) {
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            return true;
        }
        if (cls == Byte.class || cls == Byte.TYPE) {
            return true;
        }
        if (cls == Short.class || cls == Short.TYPE) {
            return true;
        }
        if (cls == Integer.class || cls == Integer.TYPE) {
            return true;
        }
        if (cls == Long.class || cls == Long.TYPE) {
            return true;
        }
        if (cls == Float.class || cls == Float.TYPE) {
            return true;
        }
        if (cls == Double.class || cls == Double.TYPE) {
            return true;
        }
        if (cls == String.class) {
            return true;
        }
        if (cls == File.class) {
            return true;
        }
        return ClassLocator.isSubclass(BaseObject.class, cls);
    }

    @Override
    public Object convert(Class cls, String value) throws Exception {
        Object result = null;
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            result = new Boolean(value);
        } else if (cls == Byte.class || cls == Byte.TYPE) {
            result = new Byte(value);
        } else if (cls == Short.class || cls == Short.TYPE) {
            result = new Short(value);
        } else if (cls == Integer.class || cls == Integer.TYPE) {
            result = new Integer(value);
        } else if (cls == Long.class || cls == Long.TYPE) {
            result = new Long(value);
        } else if (cls == Float.class || cls == Float.TYPE) {
            result = new Float(value);
        } else if (cls == Double.class || cls == Double.TYPE) {
            result = new Double(value);
        } else if (cls == String.class) {
            result = value;
        } else if (cls == File.class) {
            result = new PlaceholderFile(value).getAbsoluteFile();
        } else if (ClassLocator.isSubclass(BaseObject.class, cls)) {
            result = (BaseObject)cls.newInstance();
            ((BaseObject)result).setValue(value);
        }
        return result;
    }
}

