/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.execution;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.execution.AbstractFlowExecutionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Date;
import java.util.logging.Level;

public class ExecutionLog
extends AbstractFlowExecutionListener {
    private static final long serialVersionUID = 3877868695922876920L;
    protected PlaceholderFile m_LogFile;
    protected BufferedWriter m_Writer;
    protected transient DateFormat m_DateFormat;

    @Override
    public String globalInfo() {
        return "Generates a trace file with all activity logged.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("log-file", "logFile", new PlaceholderFile("."));
    }

    public void setLogFile(PlaceholderFile value) {
        this.m_LogFile = value;
        this.reset();
    }

    public PlaceholderFile getLogFile() {
        return this.m_LogFile;
    }

    public String logFileTipText() {
        return "The log file to write to; writing is disabled if pointing to a directory.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Writer = null;
    }

    @Override
    public void startListening() {
        super.startListening();
        this.m_DateFormat = DateUtils.getTimestampFormatterMsecs();
        if (!this.m_LogFile.isDirectory()) {
            try {
                this.m_Writer = new BufferedWriter(new FileWriter(this.m_LogFile.getAbsolutePath()));
                this.m_Writer.write("Date");
                this.m_Writer.write("\t");
                this.m_Writer.write("Actor");
                this.m_Writer.write("\t");
                this.m_Writer.write("Origin");
                this.m_Writer.write("\t");
                this.m_Writer.write("Message");
                this.m_Writer.newLine();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to open log file: " + this.m_LogFile, e);
                this.m_Writer = null;
            }
        }
    }

    protected void add(String origin, Actor actor, String msg) {
        if (this.m_Writer == null) {
            return;
        }
        try {
            this.m_Writer.write(this.m_DateFormat.format(new Date()));
            this.m_Writer.write("\t");
            this.m_Writer.write(actor.getFullName());
            this.m_Writer.write("\t");
            this.m_Writer.write(origin);
            this.m_Writer.write("\t");
            this.m_Writer.write(msg);
            this.m_Writer.newLine();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public void preInput(Actor actor, Token token) {
        this.add("preInput", actor, "#" + token.hashCode());
    }

    @Override
    public void postInput(Actor actor) {
        this.add("postInput", actor, "");
    }

    @Override
    public void preExecute(Actor actor) {
        this.add("preExecute", actor, "");
    }

    @Override
    public void postExecute(Actor actor) {
        this.add("postExecute", actor, "");
    }

    @Override
    public void preOutput(Actor actor) {
        this.add("preOutput", actor, "");
    }

    @Override
    public void postOutput(Actor actor, Token token) {
        this.add("postOutput", actor, "#" + token.hashCode());
    }

    @Override
    public void finishListening() {
        super.finishListening();
        this.m_DateFormat = null;
        if (this.m_Writer != null) {
            try {
                this.m_Writer.flush();
                this.m_Writer.close();
                this.m_Writer = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

