/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.VariableNameNoUpdate;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.sink.AbstractTextualDisplay;
import adams.gui.core.AbstractNamedHistoryPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.BufferHistoryPanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.TextEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HistoryDisplay
extends AbstractTextualDisplay {
    private static final long serialVersionUID = 3365817040968234289L;
    public static final String BACKUP_CURRENTCOUNT = "current count";
    protected int m_NumTokens;
    protected HistorySplitPanel m_HistoryPanel;
    protected JMenuItem m_MenuItemFilePrint;
    protected JMenuItem m_MenuItemEditCopy;
    protected JMenuItem m_MenuItemEditSelectAll;
    protected JMenuItem m_MenuItemViewFont;
    protected JCheckBoxMenuItem m_MenuItemViewCaret;
    protected int m_CurrentCount;
    protected boolean m_AllowMerge;
    protected boolean m_AllowSearch;
    protected boolean m_CaretAtStart;
    protected VariableNameNoUpdate m_EntryNameVariable;

    @Override
    public String globalInfo() {
        return "Actor that outputs any object that arrives at its input port via the 'toString()' method in a separate 'history' entry.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("caret-at-start", "caretAtStart", false);
        this.m_OptionManager.add("num-tokens", "numTokens", 1, -1, null);
        this.m_OptionManager.add("entry-name-variable", "entryNameVariable", new VariableNameNoUpdate("entryNameVariable"));
        this.m_OptionManager.add("allow-merge", "allowMerge", false);
        this.m_OptionManager.add("allow-search", "allowSearch", false);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_CurrentCount = 0;
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CURRENTCOUNT);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_CURRENTCOUNT, this.m_CurrentCount);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CURRENTCOUNT)) {
            this.m_CurrentCount = (Integer)state.get(BACKUP_CURRENTCOUNT);
            state.remove(BACKUP_CURRENTCOUNT);
        }
        super.restoreState(state);
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, "caretAtStart", this.m_CaretAtStart, "caret at start", ", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "numTokens", this.m_NumTokens, ", # tokens: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "entryNameVariable", this.m_EntryNameVariable, ", entry name var: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "allowMerge", this.m_AllowMerge, "merge", ", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "allowSearch", this.m_AllowSearch, "searchable", ", ");
        return result;
    }

    @Override
    protected int getDefaultWidth() {
        return 640;
    }

    @Override
    protected int getDefaultHeight() {
        return 480;
    }

    public void setCaretAtStart(boolean value) {
        this.m_CaretAtStart = value;
        this.reset();
    }

    public boolean isCaretAtStart() {
        return this.m_CaretAtStart;
    }

    public String caretAtStartTipText() {
        return "If set to true, then the caret will be positioned by default at the start and not the end (can be changed in dialog: View -> Position caret at start).";
    }

    public void setNumTokens(int value) {
        if (value >= -1) {
            this.m_NumTokens = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of tokens must be -1/0 (for unlimited) or greater than 0, provided: " + value);
        }
    }

    public int getNumTokens() {
        return this.m_NumTokens;
    }

    public String numTokensTipText() {
        return "The number of tokens to accept per history entry.";
    }

    public void setEntryNameVariable(VariableNameNoUpdate value) {
        this.m_EntryNameVariable = value;
        this.reset();
    }

    public VariableNameNoUpdate getEntryNameVariable() {
        return this.m_EntryNameVariable;
    }

    public String entryNameVariableTipText() {
        return "The variable to use for naming the entries; gets ignored if variable not available; an existing history entry gets replaced if a new one with the same name gets added.";
    }

    public void setAllowMerge(boolean value) {
        this.m_AllowMerge = value;
        this.reset();
    }

    public boolean getAllowMerge() {
        return this.m_AllowMerge;
    }

    public String allowMergeTipText() {
        return "If enabled then entries with the same name (ie when using 'entryNameVariable') get merged.";
    }

    public void setAllowSearch(boolean value) {
        this.m_AllowSearch = value;
        this.reset();
    }

    public boolean getAllowSearch() {
        return this.m_AllowSearch;
    }

    public String allowSearchTipText() {
        return "Whether to allow the user to search the entries.";
    }

    @Override
    public void clearPanel() {
        if (this.m_HistoryPanel != null) {
            this.m_HistoryPanel.clear();
        }
    }

    @Override
    protected BasePanel newPanel() {
        this.m_HistoryPanel = new HistorySplitPanel(this);
        this.m_HistoryPanel.setAllowSearch(this.m_AllowSearch);
        this.m_HistoryPanel.getHistory().setCaretAtStart(this.m_CaretAtStart);
        this.m_HistoryPanel.getHistory().addHistoryEntrySelectionListener(new AbstractNamedHistoryPanel.HistoryEntrySelectionListener(){

            @Override
            public void historyEntrySelected(AbstractNamedHistoryPanel.HistoryEntrySelectionEvent e) {
                HistoryDisplay.this.updateMenu();
            }
        });
        return this.m_HistoryPanel;
    }

    @Override
    protected JMenu createFileMenu() {
        JMenu result = super.createFileMenu();
        JMenuItem menuitem = new JMenuItem("Print...");
        menuitem.setMnemonic('P');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed P"));
        menuitem.setIcon(GUIHelper.getIcon("print.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryDisplay.this.m_HistoryPanel.getTextPanel().printText();
            }
        });
        int pos = this.indexOfMenuItem(result, this.m_MenuItemFileClose);
        result.insertSeparator(pos);
        result.insert(menuitem, pos);
        this.m_MenuItemFilePrint = menuitem;
        return result;
    }

    protected JMenu createEditMenu() {
        final TextEditorPanel fPanel = this.m_HistoryPanel.getTextPanel();
        JMenu result = new JMenu("Edit");
        result.setMnemonic('E');
        result.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HistoryDisplay.this.updateMenu();
            }
        });
        JMenuItem menuitem = new JMenuItem("Copy", GUIHelper.getIcon("copy.gif"));
        menuitem.setMnemonic('C');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed C"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fPanel.copy();
            }
        });
        result.add(menuitem);
        this.m_MenuItemEditCopy = menuitem;
        menuitem = new JMenuItem("Select all", GUIHelper.getEmptyIcon());
        menuitem.setMnemonic('S');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed A"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fPanel.selectAll();
            }
        });
        result.addSeparator();
        result.add(menuitem);
        this.m_MenuItemEditSelectAll = menuitem;
        return result;
    }

    protected JMenu createViewMenu() {
        JMenu result = new JMenu("View");
        result.setMnemonic('V');
        result.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HistoryDisplay.this.updateMenu();
            }
        });
        JMenuItem menuitem = new JMenuItem("Choose font...");
        result.add(menuitem);
        menuitem.setIcon(GUIHelper.getIcon("font.png"));
        menuitem.setMnemonic('f');
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryDisplay.this.m_HistoryPanel.getTextPanel().selectFont();
            }
        });
        this.m_MenuItemViewFont = menuitem;
        menuitem = new JCheckBoxMenuItem("Position caret at start");
        result.addSeparator();
        result.add(menuitem);
        menuitem.setMnemonic('s');
        menuitem.setSelected(this.m_CaretAtStart);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryDisplay.this.m_HistoryPanel.getHistory().setCaretAtStart(HistoryDisplay.this.m_MenuItemViewCaret.isSelected());
            }
        });
        this.m_MenuItemViewCaret = (JCheckBoxMenuItem)menuitem;
        return result;
    }

    @Override
    protected JMenuBar createMenuBar() {
        JMenuBar result = super.createMenuBar();
        result.add(this.createEditMenu());
        result.add(this.createViewMenu());
        return result;
    }

    @Override
    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        super.updateMenu();
        TextEditorPanel panel = this.m_HistoryPanel.getTextPanel();
        this.m_MenuItemFileClear.setEnabled(this.m_HistoryPanel.count() > 0);
        this.m_MenuItemEditCopy.setEnabled(panel.canCopy());
    }

    @Override
    protected boolean supportsClear() {
        return true;
    }

    @Override
    protected void clear() {
        this.m_HistoryPanel.clear();
    }

    @Override
    public String supplyText() {
        int index;
        String result = null;
        if (this.m_HistoryPanel != null && (index = this.m_HistoryPanel.getHistory().getSelectedIndex()) != -1) {
            result = ((StringBuilder)this.m_HistoryPanel.getHistory().getEntry(index)).toString();
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Object.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void display(Token token) {
        boolean newPanel = false;
        if (this.m_NumTokens > 0 && this.m_CurrentCount % this.m_NumTokens == 0) {
            newPanel = true;
        } else if (this.m_NumTokens <= 0 && this.m_CurrentCount == 0) {
            newPanel = true;
        }
        HistorySplitPanel historySplitPanel = this.m_HistoryPanel;
        synchronized (historySplitPanel) {
            if (newPanel) {
                this.m_HistoryPanel.addResult(token.getPayload().toString());
            } else {
                this.m_HistoryPanel.appendResult(token.getPayload().toString());
            }
        }
        ++this.m_CurrentCount;
    }

    @Override
    protected void cleanUpGUI() {
        if (this.m_HistoryPanel != null) {
            this.m_HistoryPanel.clear();
        }
        super.cleanUpGUI();
    }

    public static class HistorySplitPanel
    extends BasePanel {
        private static final long serialVersionUID = 5121061351955687610L;
        protected HistoryDisplay m_Owner;
        protected JSplitPane m_SplitPane;
        protected BaseStatusBar m_StatusBar;
        protected BufferHistoryPanel m_History;
        protected TextEditorPanel m_TextPanel;
        protected SimpleDateFormat m_Format;

        public HistorySplitPanel(HistoryDisplay owner) {
            super(new BorderLayout());
            this.m_Owner = owner;
            this.m_Format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            this.m_SplitPane = new JSplitPane();
            this.add((Component)this.m_SplitPane, "Center");
            this.m_TextPanel = new TextEditorPanel();
            this.m_TextPanel.setTextFont(owner.getFont());
            this.m_TextPanel.setEditable(false);
            this.m_SplitPane.setBottomComponent(this.m_TextPanel);
            this.m_History = new BufferHistoryPanel();
            this.m_History.setTextArea(this.m_TextPanel.getTextArea());
            this.m_History.addHistoryEntrySelectionListener(new AbstractNamedHistoryPanel.HistoryEntrySelectionListener(){

                @Override
                public void historyEntrySelected(AbstractNamedHistoryPanel.HistoryEntrySelectionEvent e) {
                    HistorySplitPanel.this.m_StatusBar.setStatus(Utils.flatten(e.getNames(), ", "));
                }
            });
            this.m_SplitPane.setTopComponent(this.m_History);
            this.m_SplitPane.setResizeWeight(0.1);
            this.m_SplitPane.setDividerLocation(Math.max(150, this.m_History.getPreferredSize().width));
            this.m_StatusBar = new BaseStatusBar();
            this.m_StatusBar.setMouseListenerActive(true);
            this.add((Component)this.m_StatusBar, "South");
        }

        public HistoryDisplay getOwner() {
            return this.m_Owner;
        }

        public TextEditorPanel getTextPanel() {
            return this.m_TextPanel;
        }

        public void clear() {
            this.m_History.clear();
            this.m_TextPanel.clear();
        }

        public int count() {
            return this.m_History.count();
        }

        public BufferHistoryPanel getHistory() {
            return this.m_History;
        }

        public void addResult(String result) {
            this.addResult(new StringBuilder(result));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void addResult(StringBuilder result) {
            String id;
            String var = this.m_Owner.getEntryNameVariable().getValue();
            if (this.m_Owner.getVariables().has(var)) {
                id = this.m_Owner.getVariables().get(var);
            } else {
                String baseID;
                SimpleDateFormat simpleDateFormat = this.m_Format;
                synchronized (simpleDateFormat) {
                    baseID = this.m_Format.format(new Date());
                }
                id = this.m_History.newEntryName(baseID);
            }
            if (this.m_History.hasEntry(id) && this.m_Owner.getAllowMerge()) {
                this.appendResult(result, this.m_History.indexOfEntry(id));
            } else {
                this.m_History.addEntry(id, result);
            }
            this.m_History.setSelectedEntry(id);
        }

        public void appendResult(String result) {
            this.appendResult(result, -1);
        }

        public void appendResult(String result, int index) {
            this.appendResult(new StringBuilder(result), index);
        }

        public synchronized void appendResult(StringBuilder result) {
            this.appendResult(result, -1);
        }

        public synchronized void appendResult(StringBuilder result, int index) {
            int actualIndex = index;
            if (actualIndex < 0) {
                actualIndex = this.m_History.count() - 1;
            }
            if (actualIndex < 0 || actualIndex >= this.m_History.count()) {
                this.addResult(result);
                return;
            }
            ((StringBuilder)this.m_History.getEntry(actualIndex)).append("\n").append((CharSequence)result);
            this.m_History.setSelectedIndex(actualIndex);
        }

        public void setAllowSearch(boolean value) {
            this.m_History.setAllowSearch(value);
        }

        public boolean getAllowSearch() {
            return this.m_History.getAllowSearch();
        }
    }
}

