/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.sink.AbstractSink;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.AdditionalParameterHandler;
import adams.gui.menu.TextEditor;

public class MenuItem
extends AbstractSink {
    private static final long serialVersionUID = -4210882711380055794L;
    protected AbstractMenuItemDefinition m_MenuItem;

    @Override
    public String globalInfo() {
        return "Launches a menu item from the main menu. If the menu item accepts string parameter(s) then the incoming data will be forwarded to it.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("menu-item", "menuItem", new TextEditor());
    }

    public void setMenuItem(AbstractMenuItemDefinition value) {
        this.m_MenuItem = value;
        this.reset();
    }

    public AbstractMenuItemDefinition getMenuItem() {
        return this.m_MenuItem;
    }

    public String menuItemTipText() {
        return "The menu item to launch.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "menuItem", this.m_MenuItem.getClass());
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, String[].class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            if (this.m_MenuItem instanceof AdditionalParameterHandler) {
                String[] params = this.m_InputToken.getPayload() instanceof String ? new String[]{(String)this.m_InputToken.getPayload()} : (String[])this.m_InputToken.getPayload();
                ((AdditionalParameterHandler)((Object)this.m_MenuItem)).setAdditionalParameters(params);
                this.m_MenuItem.launch();
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to launch menu item:", e);
        }
        return result;
    }
}

