/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.sink.AbstractFileWriter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Properties;

public class PropertiesFileWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = 3613018887562327088L;

    @Override
    public String globalInfo() {
        return "Writes a Java properties object to a file.";
    }

    @Override
    public String outputFileTipText() {
        return "The name of the output file.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Properties.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        Properties props = (Properties)this.m_InputToken.getPayload();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.m_OutputFile.getAbsoluteFile()));
            props.store(writer, null);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            result = this.handleException("Failed to store properties in: " + this.m_OutputFile, e);
        }
        return result;
    }
}

