/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.SerializationHelper;
import adams.flow.core.Unknown;
import adams.flow.sink.AbstractFileWriter;

public class Serialize
extends AbstractFileWriter {
    private static final long serialVersionUID = 3282341894400972003L;

    @Override
    public String globalInfo() {
        return "Saves any (serializable) Java object in a file via serialization.";
    }

    @Override
    public String outputFileTipText() {
        return "The name of the output file.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        Object input = this.m_InputToken.getPayload();
        if (SerializationHelper.isSerializable(input.getClass())) {
            try {
                SerializationHelper.write(this.m_OutputFile.getAbsolutePath(), input);
            }
            catch (Exception e) {
                result = this.handleException("Failed to serialize to: " + this.m_OutputFile, e);
            }
        } else {
            result = "Not serializable: " + input.getClass();
        }
        return result;
    }
}

