/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseObject;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.flow.core.AutomatableInteractiveActor;
import adams.flow.core.Token;
import adams.flow.source.AbstractInteractiveSource;
import adams.gui.core.GUIHelper;
import java.util.ArrayList;

public class EnterValue
extends AbstractInteractiveSource
implements AutomatableInteractiveActor {
    private static final long serialVersionUID = 8200691218381875131L;
    protected String m_Message;
    protected String m_InitialValue;
    protected BaseString[] m_SelectionValues;
    protected boolean m_NonInteractive;
    protected boolean m_UseButtons;
    protected Token m_OutputToken;
    protected GUIHelper.DialogCommunication m_Comm;

    @Override
    public String globalInfo() {
        return "Pops up a dialog, prompting the user to enter a value.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("message", "message", "Please enter a value");
        this.m_OptionManager.add("initial-value", "initialValue", "");
        this.m_OptionManager.add("selection-values", "selectionValues", new BaseString[0]);
        this.m_OptionManager.add("use-buttons", "useButtons", false);
        this.m_OptionManager.add("non-interactive", "nonInteractive", false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "message", this.m_Message);
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "stopFlowIfCanceled", this.m_StopFlowIfCanceled, "stops flow if canceled"));
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "nonInteractive", this.m_NonInteractive, "non-interactive"));
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "useButtons", this.m_UseButtons, "buttons"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public void setMessage(String value) {
        this.m_Message = value;
        this.reset();
    }

    public String getMessage() {
        return this.m_Message;
    }

    public String messageTipText() {
        return "The message to prompt the user with; variables get expanded prior to prompting user.";
    }

    public void setInitialValue(String value) {
        this.m_InitialValue = value;
        this.reset();
    }

    public String getInitialValue() {
        return this.m_InitialValue;
    }

    public String initialValueTipText() {
        return "The initial value to prompt the user with; variables get expanded prior to prompting user.";
    }

    public void setSelectionValues(BaseString[] value) {
        this.m_SelectionValues = value;
        this.reset();
    }

    public BaseString[] getSelectionValues() {
        return this.m_SelectionValues;
    }

    public String selectionValuesTipText() {
        return "The options to let the user choose from.";
    }

    public void setUseButtons(boolean value) {
        this.m_UseButtons = value;
        this.reset();
    }

    public boolean getUseButtons() {
        return this.m_UseButtons;
    }

    public String useButtonsTipText() {
        return "If enabled and selection values are available, then instead of a dropdown list a button per selection value is displayed.";
    }

    @Override
    public void setNonInteractive(boolean value) {
        this.m_NonInteractive = value;
        this.reset();
    }

    @Override
    public boolean isNonInteractive() {
        return this.m_NonInteractive;
    }

    @Override
    public String nonInteractiveTipText() {
        return "If enabled, the initial value is forwarded without user interaction.";
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    public boolean doInteract() {
        String msg = this.m_Message;
        msg = this.getVariables().expand(msg);
        String initial = this.m_InitialValue;
        initial = this.getVariables().expand(initial);
        this.m_Comm = new GUIHelper.DialogCommunication();
        if (this.m_NonInteractive) {
            this.m_OutputToken = new Token(initial);
            return true;
        }
        String value = this.m_SelectionValues.length > 0 ? GUIHelper.showInputDialog(GUIHelper.getParentComponent(this.getParentComponent()), msg, initial, BaseObject.toStringArray(this.m_SelectionValues), !this.m_UseButtons, this.getName(), this.m_Comm) : GUIHelper.showInputDialog(GUIHelper.getParentComponent(this.getParentComponent()), msg, initial, this.getName(), this.m_Comm);
        if (value != null && value.length() > 0) {
            this.m_OutputToken = new Token(value);
        }
        this.m_Comm = null;
        return value != null && value.length() > 0;
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopExecution() {
        if (this.m_Comm != null) {
            GUIHelper.DialogCommunication dialogCommunication = this.m_Comm;
            synchronized (dialogCommunication) {
                this.m_Comm.requestClose();
            }
        }
        super.stopExecution();
    }
}

