/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import adams.flow.source.newlist.AbstractListGenerator;
import adams.flow.source.newlist.FixedList;
import java.util.List;

public class NewList
extends AbstractSimpleSource {
    private static final long serialVersionUID = 7272049518765623563L;
    protected AbstractListGenerator m_Generator;
    protected String m_Separator;
    protected QuoteType m_QuoteType;

    @Override
    public String globalInfo() {
        return "Generates a list string based on the items produced by the generator and the specified separator.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", new FixedList());
        this.m_OptionManager.add("separator", "separator", ",");
        this.m_OptionManager.add("quote-type", "quoteType", (Object)QuoteType.NONE);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "generator", this.m_Generator, "generator: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "separator", "'" + this.m_Separator + "'", ", sep: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "quoteType", (Object)this.m_QuoteType, ", quote: ");
        return result;
    }

    public void setGenerator(AbstractListGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractListGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The list generator to use.";
    }

    public void setSeparator(String value) {
        this.m_Separator = value;
        this.reset();
    }

    public String getSeparator() {
        return this.m_Separator;
    }

    public String separatorTipText() {
        return "The separator to use between the list elements.";
    }

    public void setQuoteType(QuoteType value) {
        this.m_QuoteType = value;
        this.reset();
    }

    public QuoteType getQuoteType() {
        return this.m_QuoteType;
    }

    public String quoteTypeTipText() {
        return "The type of quote to use.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            List<String> elements = this.m_Generator.generate();
            StringBuilder list = new StringBuilder();
            for (String element : elements) {
                if (list.length() > 0) {
                    list.append(this.m_Separator);
                }
                switch (this.m_QuoteType) {
                    case DOUBLE: {
                        element = Utils.doubleQuote(element);
                        break;
                    }
                    case SINGLE: {
                        element = Utils.quote(element);
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled quote type: " + (Object)((Object)this.m_QuoteType));
                    }
                }
                list.append(element);
            }
            this.m_OutputToken = new Token(list.toString());
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate list!", e);
        }
        return result;
    }

    public static enum QuoteType {
        NONE,
        SINGLE,
        DOUBLE;

    }
}

