/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.random.JavaRandomDouble;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;

public class RandomNumberGenerator
extends AbstractSource {
    private static final long serialVersionUID = 6216146938771296415L;
    protected adams.data.random.RandomNumberGenerator m_Generator;
    protected int m_MaxNum;
    protected int m_Count;

    @Override
    public String globalInfo() {
        return "Random number generator. The type of random numbers depends on the chosen generator.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", new JavaRandomDouble());
        this.m_OptionManager.add("max-num", "maxNum", 1000, -1, null);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "generator", this.m_Generator);
        result = result + QuickInfoHelper.toString((OptionHandler)this, "maxNum", this.m_MaxNum, "/");
        return result;
    }

    public void setGenerator(adams.data.random.RandomNumberGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public adams.data.random.RandomNumberGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The random number generator to use.";
    }

    public void setMaxNum(int value) {
        if (value == -1 || value >= 1) {
            this.m_MaxNum = value;
            this.reset();
        } else {
            this.getLogger().warning("Maximum number must be >= 1 or -1 for unlimited, provided: " + value);
        }
    }

    public int getMaxNum() {
        return this.m_MaxNum;
    }

    public String maxNumTipText() {
        return "The maximum number of random numbers to generate; -1 means unlimited.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{Double.class};
    }

    @Override
    protected void reset() {
        super.reset();
        if (this.m_Generator != null) {
            this.m_Generator.reset();
        }
    }

    @Override
    protected String doExecute() {
        this.m_Count = 0;
        return null;
    }

    @Override
    public Token output() {
        ++this.m_Count;
        Token result = new Token(new Double(((Number)this.m_Generator.next()).doubleValue()));
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Executed && (this.m_MaxNum > -1 && this.m_Count < this.m_MaxNum || this.m_MaxNum == -1);
    }
}

