/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.sink.CallableSink;
import adams.flow.sink.ComponentSupplier;
import adams.flow.standalone.AbstractMultiView;
import adams.gui.core.BasePanel;
import adams.gui.print.JComponentWriter;
import adams.gui.print.NullWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class GridView
extends AbstractMultiView
implements ComponentSupplier {
    private static final long serialVersionUID = -4454052058077687116L;
    protected int m_NumRows;
    protected int m_NumCols;
    protected List<BasePanel> m_Panels;
    protected JComponentWriter m_Writer;

    @Override
    public String globalInfo() {
        return "Displays multiple graphical actors in a grid. The actors get added row-wise to the grid from top-left to bottom-right. The actors can be referenced in the flow using " + CallableSink.class.getName() + " actors.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-rows", "numRows", 1, 1, null);
        this.m_OptionManager.add("num-cols", "numCols", 1, 1, null);
        this.m_OptionManager.add("writer", "writer", new NullWriter());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Panels = null;
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, "numRows", this.m_NumRows, ", Rows: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "numCols", this.m_NumCols, ", Cols: ");
        return result;
    }

    public void setNumRows(int value) {
        this.m_NumRows = value;
        this.reset();
    }

    public int getNumRows() {
        return this.m_NumRows;
    }

    public String numRowsTipText() {
        return "The number of rows in the grid.";
    }

    public void setNumCols(int value) {
        this.m_NumCols = value;
        this.reset();
    }

    public int getNumCols() {
        return this.m_NumCols;
    }

    public String numColsTipText() {
        return "The number of columns in the grid.";
    }

    public void setWriter(JComponentWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public JComponentWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer to use for generating the graphics output.";
    }

    @Override
    public String actorsTipText() {
        return "The panel-generating actors to display in the grid.";
    }

    @Override
    public boolean makeVisible(AbstractMultiView.ViewWrapper wrapper) {
        return true;
    }

    @Override
    protected BasePanel newPanel() {
        BasePanel result = new BasePanel(new GridLayout(this.m_NumRows, this.m_NumCols));
        this.m_Panels = new ArrayList<BasePanel>();
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            BasePanel panel = new BasePanel(new BorderLayout());
            JLabel label = new JLabel(((AbstractActor)this.m_Actors.get(i)).getName(), 0);
            panel.add((Component)label, "Center");
            result.add(panel);
            this.m_Panels.add(panel);
        }
        return result;
    }

    @Override
    public void addPanel(AbstractActor actor, BasePanel panel) {
        int index = this.indexOf(actor.getName());
        this.m_Panels.set(index, panel);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                GridView.this.m_Panel.removeAll();
                for (JComponent jComponent : GridView.this.m_Panels) {
                    GridView.this.m_Panel.add(jComponent);
                }
                GridView.this.m_Panel.validate();
                GridView.this.m_Panel.doLayout();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public JComponent supplyComponent() {
        return this.m_Panel;
    }

    @Override
    public void wrapUp() {
        if (!(this.m_Writer instanceof NullWriter)) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        GridView.this.m_Writer.setComponent(GridView.this.supplyComponent());
                        GridView.this.m_Writer.toOutput();
                    }
                    catch (Exception e) {
                        GridView.this.handleException("Failed to write graphical output", e);
                    }
                }
            };
            SwingUtilities.invokeLater(run);
        }
        super.wrapUp();
    }

    @Override
    public void cleanUp() {
        if (this.m_Panels != null) {
            this.m_Panels.clear();
            this.m_Panels = null;
        }
        super.cleanUp();
    }
}

