/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnectionHandler;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.AbstractStandalone;
import adams.flow.standalone.DatabaseConnection;
import adams.tools.AbstractTool;
import adams.tools.InitializeTables;

public class Tool
extends AbstractStandalone {
    private static final long serialVersionUID = -295054877801672294L;
    protected AbstractTool m_Tool;

    @Override
    public String globalInfo() {
        return "Runs a tool.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("tool", "tool", new InitializeTables());
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "tool", this.m_Tool);
    }

    public void setTool(AbstractTool value) {
        this.m_Tool = value;
        this.reset();
    }

    public AbstractTool getTool() {
        return this.m_Tool;
    }

    public String toolTipText() {
        return "The tool to run.";
    }

    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return adams.db.DatabaseConnection.getSingleton();
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection(this, DatabaseConnection.class, this.getDefaultDatabaseConnection());
    }

    protected void updateDatabaseConnection() {
        if (this.m_Tool instanceof DatabaseConnectionHandler) {
            ((DatabaseConnectionHandler)((Object)this.m_Tool)).setDatabaseConnection(this.getDatabaseConnection());
        }
    }

    @Override
    protected String doExecute() {
        String result;
        try {
            this.updateDatabaseConnection();
            this.m_Tool.run();
            result = this.m_Tool.isStopped() ? "Tool was stopped!" : null;
        }
        catch (Exception e) {
            result = this.handleException("Failed to run tool: " + this.m_Tool, e);
        }
        return result;
    }

    @Override
    public void stopExecution() {
        if (this.m_Tool != null) {
            this.m_Tool.stopExecution();
        }
        super.stopExecution();
    }
}

