/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.container.DataContainer;
import adams.data.io.input.AbstractDataContainerReader;
import adams.db.DataProvider;
import adams.db.DatabaseConnectionHandler;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractDbDataProcessor;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public abstract class AbstractDataContainerFileImport<T extends DataContainer>
extends AbstractDbDataProcessor
implements ProvenanceSupporter {
    private static final long serialVersionUID = -3449734957975707303L;
    public static final String BACKUP_IDS = "ids";
    public static final String BACKUP_CONTAINERS = "containers";
    protected AbstractDataContainerReader<T> m_Reader;
    protected List<Integer> m_IDs;
    protected List<T> m_Containers;
    protected boolean m_Import;
    protected boolean m_Forward;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", this.getDefaultReader());
        this.m_OptionManager.add("forward", "forward", false);
        this.m_OptionManager.add("import", "import", true);
    }

    protected abstract AbstractDataContainerReader<T> getDefaultReader();

    public void setReader(AbstractDataContainerReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public AbstractDataContainerReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader to use for importing the containers.";
    }

    public void setForward(boolean value) {
        this.m_Forward = value;
        this.reset();
    }

    public boolean getForward() {
        return this.m_Forward;
    }

    public String forwardTipText() {
        return "If set to true then the containers are forwarded instead of the IDs.";
    }

    public void setImport(boolean value) {
        this.m_Import = value;
        this.reset();
    }

    public boolean getImport() {
        return this.m_Import;
    }

    public String importTipText() {
        return "If set to true then the containers are imported into the database.";
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_IDS);
        this.pruneBackup(BACKUP_CONTAINERS);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_IDS, this.m_IDs);
        result.put(BACKUP_CONTAINERS, this.m_Containers);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_IDS)) {
            this.m_IDs = (List)state.get(BACKUP_IDS);
            state.remove(BACKUP_IDS);
        }
        if (state.containsKey(BACKUP_CONTAINERS)) {
            this.m_Containers = (List)state.get(BACKUP_CONTAINERS);
            state.remove(BACKUP_CONTAINERS);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_IDs = new ArrayList<Integer>();
        this.m_Containers = new ArrayList<T>();
    }

    protected abstract DataProvider<T> getDataProvider();

    @Override
    protected String setUpDatabaseConnection() {
        String result = null;
        if (this.m_DatabaseConnection == null && (result = super.setUpDatabaseConnection()) == null && (this.m_Import || this.m_Reader instanceof DatabaseConnectionHandler)) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
            if (this.m_Reader instanceof DatabaseConnectionHandler) {
                ((DatabaseConnectionHandler)((Object)this.m_Reader)).setDatabaseConnection(this.m_DatabaseConnection);
            }
        }
        return result;
    }

    @Override
    protected boolean processData(File file) {
        List<T> conts;
        boolean result = false;
        this.m_Reader.setInput(new PlaceholderFile(file));
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Attempting to load '" + file + "'");
        }
        try {
            conts = this.m_Reader.read();
            if (this.isLoggingEnabled()) {
                this.getLogger().info(conts.size() + " containers read");
            }
            this.m_Reader.cleanUp();
        }
        catch (Exception e) {
            this.m_ProcessError = this.handleException("Error reading '" + file + "': ", e);
            return result;
        }
        if (conts.size() > 0) {
            result = true;
            DataProvider<DataContainer> provider = null;
            if (this.m_Import) {
                provider = this.getDataProvider();
            }
            for (int i = 0; i < conts.size(); ++i) {
                try {
                    if (this.m_Import) {
                        int id = provider.add((DataContainer)conts.get(i));
                        if (this.isLoggingEnabled()) {
                            this.getLogger().info("Container (" + conts.get(i) + ") imported: " + id);
                        }
                        if (this.m_Forward) {
                            this.m_Containers.add(conts.get(i));
                            continue;
                        }
                        this.m_IDs.add(id);
                        continue;
                    }
                    if (!this.m_Forward) continue;
                    this.m_Containers.add(conts.get(i));
                    continue;
                }
                catch (Exception e) {
                    result = false;
                    this.handleException("Error importing container (" + conts.get(i) + "): ", e);
                }
            }
        }
        return result;
    }

    protected abstract Class getDataContainerClass();

    @Override
    public Class[] generates() {
        if (this.m_Forward) {
            return new Class[]{this.getDataContainerClass()};
        }
        if (this.m_Import) {
            return new Class[]{Integer.class};
        }
        return new Class[0];
    }

    @Override
    public Token output() {
        Token result = null;
        if (this.m_Forward) {
            result = new Token(this.m_Containers.get(0));
            this.m_Containers.remove(0);
            this.updateProvenance(result);
        } else if (this.m_Import) {
            result = new Token(this.m_IDs.get(0));
            this.m_IDs.remove(0);
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        if (this.m_Forward) {
            return this.m_Containers.size() > 0;
        }
        if (this.m_Import) {
            return this.m_IDs.size() > 0;
        }
        return false;
    }

    @Override
    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, this, ((Token)cont).getPayload().getClass()));
        }
    }
}

